/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.codec;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Map;
import net.solarnetwork.codec.IndexedField;
import net.solarnetwork.codec.JsonUtils;

public enum BasicLocationField implements IndexedField
{
    Name(0, "name"),
    Country(1, "country"),
    Region(2, "region"),
    StateOrProvince(3, "stateOrProvince"),
    PostalCode(4, "postalCode"),
    Locality(5, "locality"),
    Street(6, "street"),
    Latitude(7, "lat"),
    Longitude(8, "lon"),
    Elevation(9, "el"),
    TimeZoneId(10, "zone");

    public static final Map<String, BasicLocationField> FIELD_MAP;
    private final int index;
    private final String fieldName;

    private BasicLocationField(int index, String fieldName) {
        this.index = index;
        this.fieldName = fieldName;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public Object parseValue(JsonParser parser, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        switch (this) {
            case Name: 
            case Country: 
            case Locality: 
            case PostalCode: 
            case Region: 
            case StateOrProvince: 
            case Street: 
            case TimeZoneId: {
                return parser.nextTextValue();
            }
            case Elevation: 
            case Latitude: 
            case Longitude: {
                return JsonUtils.parseDecimal(parser);
            }
        }
        return null;
    }

    @Override
    public void writeValue(JsonGenerator generator, SerializerProvider provider, Object value) throws IOException, JsonProcessingException {
        if (value == null) {
            return;
        }
        switch (this) {
            case Name: 
            case Country: 
            case Locality: 
            case PostalCode: 
            case Region: 
            case StateOrProvince: 
            case Street: 
            case TimeZoneId: {
                generator.writeStringField(this.fieldName, value.toString());
                break;
            }
            case Elevation: 
            case Latitude: 
            case Longitude: {
                generator.writeNumberField(this.fieldName, (BigDecimal)value);
                break;
            }
        }
    }

    static {
        FIELD_MAP = IndexedField.fieldMap(BasicLocationField.class);
    }
}

