/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.codec;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import net.solarnetwork.codec.BasicLocationDeserializer;
import net.solarnetwork.codec.BasicLocationSerializer;
import net.solarnetwork.codec.IndexedField;
import net.solarnetwork.codec.JsonUtils;
import net.solarnetwork.domain.Location;
import net.solarnetwork.domain.datum.ObjectDatumKind;

public enum BasicObjectDatumStreamMetadataField implements IndexedField
{
    StreamId(0, "streamId"),
    TimeZoneId(1, "zone"),
    ObjectDatumKind(2, "kind"),
    ObjectId(3, "objectId"),
    SourceId(4, "sourceId"),
    Location(5, "location"),
    Instantaneous(6, "i"),
    Accumulating(7, "a"),
    Status(8, "s");

    public static final Map<String, BasicObjectDatumStreamMetadataField> FIELD_MAP;
    private final int index;
    private final String fieldName;

    private BasicObjectDatumStreamMetadataField(int index, String fieldName) {
        this.index = index;
        this.fieldName = fieldName;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public Object parseValue(JsonParser parser, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        switch (this) {
            case StreamId: {
                return UUID.fromString(parser.nextTextValue());
            }
            case TimeZoneId: 
            case SourceId: {
                return parser.nextTextValue();
            }
            case ObjectDatumKind: {
                return net.solarnetwork.domain.datum.ObjectDatumKind.forKey(parser.nextTextValue());
            }
            case ObjectId: {
                return parser.nextLongValue(0L);
            }
            case Location: {
                parser.nextToken();
                return BasicLocationDeserializer.INSTANCE.deserialize(parser, ctxt);
            }
            case Instantaneous: 
            case Accumulating: 
            case Status: {
                return JsonUtils.parseStringArray(parser);
            }
        }
        return null;
    }

    @Override
    public void writeValue(JsonGenerator generator, SerializerProvider provider, Object value) throws IOException, JsonProcessingException {
        if (value == null) {
            return;
        }
        switch (this) {
            case StreamId: 
            case TimeZoneId: 
            case SourceId: {
                generator.writeStringField(this.fieldName, value.toString());
                break;
            }
            case ObjectDatumKind: {
                generator.writeStringField(this.fieldName, Character.toString(((ObjectDatumKind)((Object)value)).getKey()));
                break;
            }
            case ObjectId: {
                generator.writeNumberField(this.fieldName, ((Long)value).longValue());
                break;
            }
            case Location: {
                generator.writeFieldName(this.fieldName);
                BasicLocationSerializer.INSTANCE.serialize((Location)value, generator, provider);
                break;
            }
            case Instantaneous: 
            case Accumulating: 
            case Status: {
                JsonUtils.writeStringArrayField(generator, this.fieldName, (String[])value);
                break;
            }
        }
    }

    static {
        FIELD_MAP = IndexedField.fieldMap(BasicObjectDatumStreamMetadataField.class);
    }
}

