/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.codec;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.Instant;
import java.util.UUID;
import net.solarnetwork.codec.JsonUtils;
import net.solarnetwork.domain.datum.BasicStreamDatum;
import net.solarnetwork.domain.datum.DatumProperties;
import net.solarnetwork.domain.datum.StreamDatum;

public class BasicStreamDatumArrayDeserializer
extends StdScalarDeserializer<StreamDatum> {
    private static final long serialVersionUID = -7518473762908606824L;
    public static final BasicStreamDatumArrayDeserializer INSTANCE = new BasicStreamDatumArrayDeserializer();

    public BasicStreamDatumArrayDeserializer() {
        super(StreamDatum.class);
    }

    public StreamDatum deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonToken t = p.currentToken();
        if (t == JsonToken.VALUE_NULL) {
            return null;
        }
        if (p.isExpectedStartArrayToken()) {
            long ts = p.nextLongValue(0L);
            long idHi = p.nextLongValue(0L);
            long idLo = p.nextLongValue(0L);
            if (ts < 1L || idHi == 0L || idLo == 0L) {
                throw new JsonParseException(p, "Unable to parse StreamDatum (timestamp or stream ID missing)");
            }
            BigDecimal[] i = JsonUtils.parseDecimalArray(p);
            BigDecimal[] a = JsonUtils.parseDecimalArray(p);
            String[] s = JsonUtils.parseStringArray(p);
            String[] tags = JsonUtils.parseStringArray(p);
            p.nextToken();
            return new BasicStreamDatum(new UUID(idHi, idLo), Instant.ofEpochMilli(ts), DatumProperties.propertiesOf(i, a, s, tags));
        }
        throw new JsonParseException(p, "Unable to parse StreamDatum (not an array)");
    }
}

