/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.codec;

import com.fasterxml.jackson.databind.ObjectMapper;
import net.solarnetwork.codec.PropertySerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONStringPropertySerializer
implements PropertySerializer {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private ObjectMapper objectMapper;

    @Override
    public Object serialize(Object data, String propertyName, Object propertyValue) {
        try {
            return this.objectMapper.writeValueAsString(propertyValue);
        }
        catch (Exception e) {
            this.log.error("Exception marshalling {} to JSON", propertyValue, (Object)e);
            return null;
        }
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }
}

