/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.codec;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.solarnetwork.codec.PropertySerializer;
import net.solarnetwork.codec.PropertySerializerRegistrar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ClassUtils;

public class JavaBeanXmlSerializer
implements PropertySerializer {
    private static final ThreadLocal<SimpleDateFormat> SDF = new ThreadLocal();
    private final String rootElementName = "root";
    private final boolean singleBeanAsRoot = true;
    private final boolean useModelTimeZoneForDates = true;
    private final String modelKey;
    private final Set<String> classNamesAllowedForNesting = null;
    private final PropertySerializerRegistrar propertySerializerRegistrar = null;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public JavaBeanXmlSerializer() {
        this.modelKey = null;
    }

    @Override
    public Object serialize(Object data, String propertyName, Object propertyValue) {
        this.setupDateFormat(null);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        XMLStreamWriter writer = this.startXml(out);
        try {
            this.outputObject(propertyValue, propertyName, writer);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.endXml(writer);
        }
        return out.toString();
    }

    public void renderBean(Object bean, OutputStream out) {
        this.setupDateFormat(null);
        XMLStreamWriter writer = this.startXml(out);
        try {
            this.outputObject(bean, null, writer);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.endXml(writer);
        }
    }

    public void renderMap(Map<String, ?> model, OutputStream out) {
        Map<String, Object> finalModel = this.setupDateFormat(model);
        XMLStreamWriter writer = this.startXml(out);
        try {
            Object singleBean;
            Object object;
            if (finalModel.size() == 1) {
                Objects.requireNonNull(this);
                object = finalModel.values().iterator().next();
            } else {
                object = singleBean = null;
            }
            if (singleBean != null) {
                this.outputObject(singleBean, finalModel.keySet().iterator().next().toString(), writer);
            } else {
                this.writeElement(this.rootElementName, null, writer, false);
                for (Map.Entry<String, Object> me : finalModel.entrySet()) {
                    this.outputObject(me.getValue(), me.getKey(), writer);
                }
                writer.writeEndElement();
            }
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.endXml(writer);
        }
    }

    private XMLStreamWriter startXml(OutputStream out) {
        XMLStreamWriter writer = null;
        try {
            writer = XMLOutputFactory.newFactory().createXMLStreamWriter(out);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
        catch (FactoryConfigurationError e) {
            throw new RuntimeException(e);
        }
        return writer;
    }

    private void endXml(XMLStreamWriter writer) {
        try {
            writer.writeEndDocument();
            writer.flush();
        }
        catch (XMLStreamException xMLStreamException) {
        }
        finally {
            SDF.remove();
        }
    }

    private Map<String, Object> setupDateFormat(Map<String, ?> model) {
        TimeZone tz = TimeZone.getTimeZone("GMT");
        LinkedHashMap<String, Object> result = null;
        if (model != null) {
            result = new LinkedHashMap<String, Object>();
            for (Map.Entry<String, ?> me : model.entrySet()) {
                Object o = me.getValue();
                if (o instanceof TimeZone) {
                    tz = (TimeZone)o;
                    continue;
                }
                if (this.modelKey != null) {
                    if (!this.modelKey.equals(me.getKey())) continue;
                    result.put(this.modelKey, o);
                    continue;
                }
                result.put(me.getKey(), o);
            }
        }
        SimpleDateFormat sdf = new SimpleDateFormat();
        if (tz.getRawOffset() == 0) {
            sdf.applyPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        } else {
            sdf.applyPattern("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        }
        sdf.setTimeZone(tz);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("TZ offset " + tz.getRawOffset());
        }
        SDF.set(sdf);
        return result;
    }

    private void outputObject(Object o, String name, XMLStreamWriter out) throws XMLStreamException {
        if (o instanceof Collection) {
            Collection col = (Collection)o;
            this.outputCollection(col, name, out);
        } else if (o instanceof Map) {
            Map map = (Map)o;
            this.outputMap(map, name, out);
        } else if (o instanceof String || o instanceof Number) {
            LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>(2);
            params.put("type", ClassUtils.getShortName(o.getClass()));
            params.put("value", o);
            this.writeElement("value", params, out, true);
        } else {
            String elementName = o == null ? name : ClassUtils.getShortName(o.getClass());
            this.writeElement(elementName, o, out, true);
        }
    }

    private void outputMap(Map<?, ?> map, String name, XMLStreamWriter out) throws XMLStreamException {
        this.writeElement(name, null, out, false);
        for (Map.Entry<?, ?> me : map.entrySet()) {
            String entryName = me.getKey().toString();
            out.writeStartElement("entry");
            out.writeAttribute("key", entryName);
            Object value = me.getValue();
            if (value instanceof Collection) {
                for (Object o : (Collection)value) {
                    this.outputObject(o, "value", out);
                }
            } else {
                this.outputObject(value, null, out);
            }
            out.writeEndElement();
        }
        out.writeEndElement();
    }

    private void outputCollection(Collection<?> col, String name, XMLStreamWriter out) throws XMLStreamException {
        this.writeElement(name, null, out, false);
        for (Object o : col) {
            this.outputObject(o, null, out);
        }
        out.writeEndElement();
    }

    private void writeElement(String name, Map<?, ?> props, XMLStreamWriter out, boolean close) throws XMLStreamException {
        out.writeStartElement(name);
        LinkedHashMap<String, Object> nested = null;
        if (props != null) {
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                String key = entry.getKey().toString();
                Object val = entry.getValue();
                if (this.propertySerializerRegistrar != null) {
                    val = this.propertySerializerRegistrar.serializeProperty(name, val.getClass(), props, val);
                }
                if (val instanceof Date) {
                    Date date;
                    SimpleDateFormat sdf = SDF.get();
                    StringBuilder buf = new StringBuilder(sdf.format(date = (Date)val));
                    if (buf.charAt(buf.length() - 1) != 'Z') {
                        buf.insert(buf.length() - 2, ':');
                    }
                    val = buf.toString();
                } else if (val instanceof Collection) {
                    if (nested == null) {
                        nested = new LinkedHashMap<String, Object>(5);
                    }
                    nested.put(key, val);
                    val = null;
                } else if (val instanceof Map) {
                    if (nested == null) {
                        nested = new LinkedHashMap(5);
                    }
                    nested.put(key, val);
                    val = null;
                } else if (this.classNamesAllowedForNesting != null && !(val instanceof Enum)) {
                    for (String prefix : this.classNamesAllowedForNesting) {
                        if (!val.getClass().getName().startsWith(prefix)) continue;
                        if (nested == null) {
                            nested = new LinkedHashMap(5);
                        }
                        nested.put(key, val);
                        val = null;
                        break;
                    }
                }
                if (val == null) continue;
                String attVal = val.toString();
                out.writeAttribute(key, attVal);
            }
        }
        if (nested != null) {
            for (Map.Entry<Object, Object> entry : nested.entrySet()) {
                this.outputObject(entry.getValue(), (String)entry.getKey(), out);
            }
            if (close) {
                out.writeEndElement();
            }
        }
    }

    private void writeElement(String name, Object bean, XMLStreamWriter out, boolean close) throws XMLStreamException {
        Object o;
        if (this.propertySerializerRegistrar != null && bean != null && (o = this.propertySerializerRegistrar.serializeProperty(name, bean.getClass(), bean, bean)) != bean) {
            if (o != null) {
                this.outputObject(o, name, out);
            }
            return;
        }
        Map<String, Object> props = net.solarnetwork.util.ClassUtils.getBeanProperties(bean, null, true);
        this.writeElement(name, props, out, close);
    }

    public Map<String, Object> parseXml(InputStream in) {
        LinkedList stack = new LinkedList();
        LinkedHashMap result = null;
        XMLStreamReader reader = this.startParse(in);
        try {
            boolean parsing = true;
            while (parsing) {
                int eventType = reader.next();
                switch (eventType) {
                    case 8: {
                        parsing = false;
                        break;
                    }
                    case 1: {
                        String name = reader.getLocalName();
                        if (stack.isEmpty()) {
                            result = new LinkedHashMap();
                            stack.push(result);
                        } else {
                            LinkedHashMap el = new LinkedHashMap();
                            this.putMapValue((Map)stack.peek(), name, el);
                            stack.push(el);
                        }
                        this.parseElement((Map)stack.peek(), reader);
                        break;
                    }
                    case 2: {
                        stack.pop();
                    }
                }
            }
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.endParse(reader);
        }
        return result;
    }

    private void parseElement(Map<String, Object> result, XMLStreamReader reader) {
        int attrCount = reader.getAttributeCount();
        for (int i = 0; i < attrCount; ++i) {
            String name = reader.getAttributeLocalName(i);
            String val = reader.getAttributeValue(i);
            this.putMapValue(result, name, val);
        }
    }

    private void putMapValue(Map<String, Object> result, String name, Object val) {
        if (result.containsKey(name)) {
            Object existingVal = result.get(name);
            if (existingVal instanceof List) {
                ((List)existingVal).add(val);
            } else {
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(existingVal);
                list.add(val);
                result.put(name, list);
            }
        } else {
            result.put(name, val);
        }
    }

    private XMLStreamReader startParse(InputStream in) {
        XMLStreamReader reader = null;
        try {
            reader = XMLInputFactory.newFactory().createXMLStreamReader(in);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
        catch (FactoryConfigurationError e) {
            throw new RuntimeException(e);
        }
        return reader;
    }

    private void endParse(XMLStreamReader reader) {
        try {
            reader.close();
        }
        catch (XMLStreamException xMLStreamException) {
            // empty catch block
        }
    }
}

