/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.codec;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import java.io.IOException;
import java.io.Serializable;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import net.solarnetwork.util.DateUtils;

public final class JsonDateUtils
implements Serializable {
    private static final long serialVersionUID = 8430495610507712465L;

    private JsonDateUtils() {
    }

    public static class LocalTimeDeserializer
    extends com.fasterxml.jackson.datatype.jsr310.deser.LocalTimeDeserializer {
        private static final long serialVersionUID = -6074927087464237331L;
        public static final JsonDeserializer<LocalTime> INSTANCE = new LocalTimeDeserializer();

        public LocalTimeDeserializer() {
            super(DateUtils.LOCAL_TIME);
        }
    }

    public static class LocalDateTimeDeserializer
    extends com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer {
        private static final long serialVersionUID = -8187990594614635776L;
        public static final JsonDeserializer<LocalDateTime> INSTANCE = new LocalDateTimeDeserializer();

        public LocalDateTimeDeserializer() {
            super(DateUtils.ISO_DATE_TIME_ALT_UTC);
        }

        public LocalDateTime deserialize(JsonParser parser, DeserializationContext context) throws IOException {
            try {
                return super.deserialize(parser, context);
            }
            catch (InvalidFormatException e) {
                Object v = e.getValue();
                if (v instanceof String) {
                    try {
                        return DateTimeFormatter.ISO_LOCAL_DATE_TIME.parse((CharSequence)v.toString(), LocalDateTime::from);
                    }
                    catch (DateTimeParseException dateTimeParseException) {
                        // empty catch block
                    }
                }
                throw e;
            }
        }
    }

    public static class ZonedDateTimeDeserializer
    extends com.fasterxml.jackson.datatype.jsr310.deser.InstantDeserializer<ZonedDateTime> {
        private static final long serialVersionUID = 461897970976758049L;
        public static final JsonDeserializer<ZonedDateTime> INSTANCE = new ZonedDateTimeDeserializer();

        public ZonedDateTimeDeserializer() {
            super(ZonedDateTime.class, DateUtils.ISO_DATE_TIME_ALT_UTC, ZonedDateTime::from, a -> ZonedDateTime.ofInstant(Instant.ofEpochMilli(a.value), a.zoneId), a -> ZonedDateTime.ofInstant(Instant.ofEpochSecond(a.integer, a.fraction), a.zoneId), ZonedDateTime::withZoneSameInstant, false);
        }

        public ZonedDateTime deserialize(JsonParser parser, DeserializationContext context) throws IOException {
            try {
                return (ZonedDateTime)super.deserialize(parser, context);
            }
            catch (InvalidFormatException e) {
                Object v = e.getValue();
                if (v instanceof String) {
                    try {
                        return DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse((CharSequence)v.toString(), ZonedDateTime::from);
                    }
                    catch (DateTimeParseException dateTimeParseException) {
                        // empty catch block
                    }
                }
                throw e;
            }
        }
    }

    public static class InstantDeserializer
    extends com.fasterxml.jackson.datatype.jsr310.deser.InstantDeserializer<Instant> {
        private static final long serialVersionUID = 6619624665216114464L;
        public static final JsonDeserializer<Instant> INSTANCE = new InstantDeserializer();

        public InstantDeserializer() {
            super(Instant.class, DateUtils.ISO_DATE_TIME_ALT_UTC, Instant::from, a -> Instant.ofEpochMilli(a.value), a -> Instant.ofEpochSecond(a.integer, a.fraction), null, true);
        }

        public Instant deserialize(JsonParser parser, DeserializationContext context) throws IOException {
            try {
                return (Instant)super.deserialize(parser, context);
            }
            catch (InvalidFormatException e) {
                Object v = e.getValue();
                if (v instanceof String) {
                    try {
                        return DateTimeFormatter.ISO_INSTANT.parse((CharSequence)v.toString(), Instant::from);
                    }
                    catch (DateTimeParseException e2) {
                        try {
                            return DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse((CharSequence)v.toString(), Instant::from);
                        }
                        catch (DateTimeException dateTimeException) {
                            // empty catch block
                        }
                    }
                }
                throw e;
            }
        }
    }

    public static class LocalTimeSerializer
    extends com.fasterxml.jackson.datatype.jsr310.ser.LocalTimeSerializer {
        private static final long serialVersionUID = 196884631172254679L;
        public static final JsonSerializer<LocalTime> INSTANCE = new LocalTimeSerializer();

        public LocalTimeSerializer() {
            super(DateUtils.LOCAL_TIME);
        }
    }

    public static class LocalDateTimeSerializer
    extends com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer {
        private static final long serialVersionUID = 8528306055696764724L;
        public static final JsonSerializer<LocalDateTime> INSTANCE = new LocalDateTimeSerializer();

        public LocalDateTimeSerializer() {
            super(DateUtils.ISO_DATE_TIME_ALT_UTC);
        }
    }

    public static class ZonedDateTimeSerializer
    extends com.fasterxml.jackson.datatype.jsr310.ser.ZonedDateTimeSerializer {
        private static final long serialVersionUID = 6913055308929776378L;
        public static final JsonSerializer<ZonedDateTime> INSTANCE = new ZonedDateTimeSerializer();

        public ZonedDateTimeSerializer() {
            super(DateUtils.ISO_DATE_TIME_ALT_UTC);
        }
    }

    public static class InstantSerializer
    extends com.fasterxml.jackson.datatype.jsr310.ser.InstantSerializer {
        private static final long serialVersionUID = 2056512911882404402L;
        public static final JsonSerializer<Instant> INSTANCE = new InstantSerializer();

        public InstantSerializer() {
            super(com.fasterxml.jackson.datatype.jsr310.ser.InstantSerializer.INSTANCE, null, null, DateUtils.ISO_DATE_TIME_ALT_UTC);
        }
    }
}

