/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.codec;

import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import net.solarnetwork.codec.PropertySerializer;

public class TemporalPropertySerializer
implements PropertySerializer {
    private final DateTimeFormatter formatter;

    public TemporalPropertySerializer(String pattern) {
        this(pattern, ZoneOffset.UTC);
    }

    public TemporalPropertySerializer(String pattern, ZoneId zone) {
        this(zone != null ? DateTimeFormatter.ofPattern(pattern).withZone(zone) : DateTimeFormatter.ofPattern(pattern));
    }

    public TemporalPropertySerializer(DateTimeFormatter formatter) {
        if (formatter == null) {
            throw new IllegalArgumentException("The formatter argument must not be null.");
        }
        this.formatter = formatter;
    }

    @Override
    public Object serialize(Object data, String propertyName, Object propertyValue) {
        if (!(propertyValue instanceof TemporalAccessor)) {
            return null;
        }
        return this.formatter.format((TemporalAccessor)propertyValue);
    }
}

