/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.dao.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import javax.sql.DataSource;
import net.solarnetwork.dao.BulkLoadingDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.SqlProvider;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

public abstract class JdbcBulkLoadingContextSupport<T>
implements BulkLoadingDao.LoadingContext<T>,
SqlProvider {
    public static final int DEFAULT_BATCH_SIZE = 100;
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final PlatformTransactionManager txManager;
    private final DataSource dataSource;
    private final String sql;
    private final BulkLoadingDao.LoadingOptions options;
    private final BulkLoadingDao.LoadingExceptionHandler<T> exceptionHandler;
    private final TransactionStatus transaction;
    private final int batchSize;
    private long numLoaded;
    private long numCommitted;
    private Connection con;
    private PreparedStatement stmt;
    private TransactionStatus batchTransaction;
    private CountAwareCheckpoint transactionCheckpoint;
    private T lastLoadedEntity;

    public JdbcBulkLoadingContextSupport(PlatformTransactionManager txManager, DataSource dataSource, String sql, BulkLoadingDao.LoadingOptions options, BulkLoadingDao.LoadingExceptionHandler<T> exceptionHandler) {
        this.txManager = txManager;
        this.dataSource = dataSource;
        this.sql = sql;
        if (options == null) {
            throw new IllegalArgumentException("The LoadingOptions argument cannot be null");
        }
        this.options = options;
        this.exceptionHandler = exceptionHandler;
        if (options.getTransactionMode() == BulkLoadingDao.LoadingTransactionMode.SingleTransaction || options.getTransactionMode() == BulkLoadingDao.LoadingTransactionMode.TransactionCheckpoints) {
            this.log.debug("Starting new bulk load [{}] overall transaction", (Object)options.getName());
            DefaultTransactionDefinition txDef = new DefaultTransactionDefinition();
            txDef.setPropagationBehavior(3);
            this.transaction = txManager.getTransaction((TransactionDefinition)txDef);
        } else {
            this.transaction = null;
        }
        this.batchSize = options.getBatchSize() != null && options.getBatchSize() > 0 ? options.getBatchSize() : 100;
        this.numLoaded = 0L;
    }

    @Override
    public BulkLoadingDao.LoadingOptions getOptions() {
        return this.options;
    }

    @Override
    public long getLoadedCount() {
        return this.numLoaded;
    }

    @Override
    public long getCommittedCount() {
        return this.numCommitted;
    }

    protected Connection getConnection() throws SQLException {
        Connection c = this.con;
        if (c != null) {
            return c;
        }
        c = DataSourceUtils.getConnection((DataSource)this.dataSource);
        c.setAutoCommit(this.options.getTransactionMode() == BulkLoadingDao.LoadingTransactionMode.NoTransaction);
        this.con = c;
        return c;
    }

    private PreparedStatement getPreparedStatement() throws SQLException {
        PreparedStatement ps;
        if (this.stmt != null) {
            return this.stmt;
        }
        this.stmt = ps = this.createJdbcStatement(this.getConnection());
        return ps;
    }

    @Override
    public T getLastLoadedEntity() {
        return this.lastLoadedEntity;
    }

    @Override
    public final void load(T entity) {
        block5: {
            this.lastLoadedEntity = entity;
            try {
                if (this.options.getTransactionMode() == BulkLoadingDao.LoadingTransactionMode.BatchTransactions && this.numLoaded % (long)this.batchSize == 0L) {
                    if (this.batchTransaction != null) {
                        this.commit();
                    }
                    this.log.debug("Starting new bulk load [{}] batch transaction @ row {}", (Object)this.options.getName(), (Object)this.numLoaded);
                    DefaultTransactionDefinition txDef = new DefaultTransactionDefinition();
                    txDef.setPropagationBehavior(3);
                    this.batchTransaction = this.txManager.getTransaction((TransactionDefinition)txDef);
                }
                if (this.doLoad(entity, this.getPreparedStatement(), this.numLoaded)) {
                    ++this.numLoaded;
                }
            }
            catch (Exception e) {
                if (this.exceptionHandler == null) break block5;
                this.exceptionHandler.handleLoadingException(e, this);
            }
        }
    }

    protected abstract boolean doLoad(T var1, PreparedStatement var2, long var3) throws SQLException;

    @Override
    public void createCheckpoint() {
        if (this.options.getTransactionMode() == BulkLoadingDao.LoadingTransactionMode.TransactionCheckpoints && this.transaction != null && !this.transaction.isCompleted()) {
            Object checkpoint = this.transaction.createSavepoint();
            if (this.transactionCheckpoint != null) {
                this.transaction.releaseSavepoint(this.transactionCheckpoint.savepoint);
            }
            this.transactionCheckpoint = new CountAwareCheckpoint(checkpoint, this.numLoaded);
            this.numCommitted = this.numLoaded;
        }
    }

    @Override
    public void commit() {
        if (this.batchTransaction != null) {
            this.log.debug("Committing bulk load [{}] batch transaction @ row {}", (Object)this.options.getName(), (Object)this.numLoaded);
            this.txManager.commit(this.batchTransaction);
            this.batchTransaction = null;
        } else if (this.transaction != null && !this.transaction.isCompleted()) {
            this.log.debug("Committing bulk load [{}] overall transaction @ row {}", (Object)this.options.getName(), (Object)this.numLoaded);
            this.txManager.commit(this.transaction);
        }
        this.numCommitted = this.numLoaded;
        this.close();
        this.stmt = null;
        this.con = null;
    }

    @Override
    public void rollback() {
        if (this.transactionCheckpoint != null && this.transaction != null) {
            this.transaction.rollbackToSavepoint(this.transactionCheckpoint.savepoint);
            this.transaction.releaseSavepoint(this.transactionCheckpoint.savepoint);
            this.numLoaded = this.transactionCheckpoint.count;
            this.transactionCheckpoint = null;
        } else if (this.batchTransaction != null && !this.batchTransaction.isCompleted()) {
            this.batchTransaction.setRollbackOnly();
            this.txManager.rollback(this.batchTransaction);
            this.numLoaded = this.numCommitted;
            this.batchTransaction = null;
        } else if (this.transaction != null && !this.transaction.isCompleted()) {
            this.txManager.rollback(this.transaction);
            this.numLoaded = this.numCommitted;
        }
    }

    @Override
    public void close() {
        if (this.stmt != null) {
            try {
                if (!this.stmt.isClosed()) {
                    this.stmt.close();
                }
            }
            catch (SQLException e) {
                this.log.warn("Error closing bulk loading statement", (Throwable)e);
            }
        }
        try {
            if (this.batchTransaction != null && !this.batchTransaction.isCompleted()) {
                this.txManager.rollback(this.batchTransaction);
            } else if (this.transaction != null && !this.transaction.isCompleted()) {
                this.txManager.rollback(this.transaction);
            }
        }
        catch (Exception e) {
            this.log.warn("Error rolling back transaction", (Throwable)e);
        }
        if (this.con != null) {
            try {
                if (!this.con.isClosed()) {
                    this.con.close();
                }
            }
            catch (SQLException e) {
                this.log.warn("Error closing bulk loading connection", (Throwable)e);
            }
            finally {
                DataSourceUtils.releaseConnection((Connection)this.con, (DataSource)this.dataSource);
            }
        }
    }

    protected PreparedStatement createJdbcStatement(Connection con) throws SQLException {
        return con.prepareCall(this.getSql());
    }

    public PlatformTransactionManager getTransactionManager() {
        return this.txManager;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public String getSql() {
        return this.sql;
    }

    public BulkLoadingDao.LoadingExceptionHandler<T> getExceptionHandler() {
        return this.exceptionHandler;
    }

    private static class CountAwareCheckpoint {
        private final long count;
        private final Object savepoint;

        private CountAwareCheckpoint(Object savepoint, long count) {
            this.savepoint = savepoint;
            this.count = count;
        }
    }
}

