/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.domain;

public enum AcPhase {
    PhaseA(1, 'a'),
    PhaseB(2, 'b'),
    PhaseC(3, 'c'),
    Total(0, 't');

    private final int number;
    private final char key;

    private AcPhase(int n2, char key) {
        this.number = n2;
        this.key = key;
    }

    public int getNumber() {
        return this.number;
    }

    public char getKey() {
        return this.key;
    }

    public String withKey(String value) {
        return (value != null ? value : "") + '_' + this.key;
    }

    public String getLineKey() {
        switch (this) {
            case Total: {
                return "t";
            }
            case PhaseA: {
                return "ab";
            }
            case PhaseB: {
                return "bc";
            }
            case PhaseC: {
                return "ca";
            }
        }
        return "";
    }

    public String withLineKey(String value) {
        return (value != null ? value : "") + '_' + this.getLineKey();
    }

    public AcPhase forNumber(int n) {
        switch (n) {
            case 0: {
                return Total;
            }
            case 1: {
                return PhaseA;
            }
            case 2: {
                return PhaseB;
            }
            case 3: {
                return PhaseC;
            }
        }
        throw new IllegalArgumentException("Number " + n + " is not a valid AcPhase");
    }

    public AcPhase forKey(char key) {
        switch (key) {
            case 't': {
                return Total;
            }
            case 'a': {
                return PhaseA;
            }
            case 'b': {
                return PhaseB;
            }
            case 'c': {
                return PhaseC;
            }
        }
        throw new IllegalArgumentException("Key " + key + " is not a valid AcPhase");
    }
}

