/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.LocalDate;
import net.solarnetwork.domain.DeviceInfo;

@JsonDeserialize(builder=Builder.class)
@JsonPropertyOrder(value={"name", "manufacturer", "modelName", "version", "serialNumber", "manufactureDate", "deviceAddress"})
public class BasicDeviceInfo
implements DeviceInfo {
    private final String name;
    private final String manufacturer;
    private final String modelName;
    private final String version;
    private final String serialNumber;
    private final LocalDate manufactureDate;
    private final String deviceAddress;

    public BasicDeviceInfo(String manufacturer, String modelName, String version, String serialNumber, LocalDate manufactureDate) {
        this(BasicDeviceInfo.builder().withManufacturer(manufacturer).withModelName(modelName).withVersion(version).withSerialNumber(serialNumber).withManufactureDate(manufactureDate));
    }

    private BasicDeviceInfo(Builder builder) {
        this.name = builder.name;
        this.manufacturer = builder.manufacturer;
        this.modelName = builder.modelName;
        this.version = builder.version;
        this.serialNumber = builder.serialNumber;
        this.manufactureDate = builder.manufactureDate;
        this.deviceAddress = builder.deviceAddress;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builderFrom(DeviceInfo basicDeviceInfo) {
        return new Builder(basicDeviceInfo);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getManufacturer() {
        return this.manufacturer;
    }

    @Override
    public String getModelName() {
        return this.modelName;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getSerialNumber() {
        return this.serialNumber;
    }

    @Override
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd")
    public LocalDate getManufactureDate() {
        return this.manufactureDate;
    }

    @Override
    public String getDeviceAddress() {
        return this.deviceAddress;
    }

    public static final class Builder {
        private String name;
        private String manufacturer;
        private String modelName;
        private String version;
        private String serialNumber;
        private LocalDate manufactureDate;
        private String deviceAddress;

        private Builder() {
        }

        private Builder(DeviceInfo basicDeviceInfo) {
            this.name = basicDeviceInfo.getName();
            this.manufacturer = basicDeviceInfo.getManufacturer();
            this.modelName = basicDeviceInfo.getModelName();
            this.version = basicDeviceInfo.getVersion();
            this.serialNumber = basicDeviceInfo.getSerialNumber();
            this.manufactureDate = basicDeviceInfo.getManufactureDate();
            this.deviceAddress = basicDeviceInfo.getDeviceAddress();
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withManufacturer(String manufacturer) {
            this.manufacturer = manufacturer;
            return this;
        }

        public Builder withModelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public Builder withVersion(String version) {
            this.version = version;
            return this;
        }

        public Builder withSerialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
            return this;
        }

        public Builder withManufactureDate(LocalDate manufactureDate) {
            this.manufactureDate = manufactureDate;
            return this;
        }

        public Builder withDeviceAddress(String deviceAddress) {
            this.deviceAddress = deviceAddress;
            return this;
        }

        public BasicDeviceInfo build() {
            return new BasicDeviceInfo(this);
        }

        public boolean isEmpty() {
            return !(this.name != null && !this.name.isEmpty() || this.manufacturer != null && !this.manufacturer.isEmpty() || this.modelName != null && !this.modelName.isEmpty() || this.version != null && !this.version.isEmpty() || this.serialNumber != null && !this.serialNumber.isEmpty() || this.manufactureDate != null || this.deviceAddress != null && !this.deviceAddress.isEmpty());
        }
    }
}

