/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.domain;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import net.solarnetwork.service.IdentifiableConfiguration;
import net.solarnetwork.util.CollectionUtils;
import net.solarnetwork.util.StringUtils;

@JsonPropertyOrder(value={"name", "serviceIdentifier", "serviceProperties"})
public class BasicIdentifiableConfiguration
implements IdentifiableConfiguration,
Serializable {
    private static final long serialVersionUID = 8272531095755880837L;
    private String name;
    private String serviceIdentifier;
    private Map<String, Object> serviceProps;

    public BasicIdentifiableConfiguration() {
    }

    public BasicIdentifiableConfiguration(IdentifiableConfiguration other) {
        if (other == null) {
            return;
        }
        this.setName(other.getName());
        this.setServiceIdentifier(other.getServiceIdentifier());
        if (other.getServiceProperties() != null) {
            LinkedHashMap<String, Object> sprops = new LinkedHashMap<String, Object>(other.getServiceProperties());
            this.setServiceProps(sprops);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append("{");
        if (this.name != null) {
            builder.append("name=");
            builder.append(this.name);
            builder.append(", ");
        }
        if (this.serviceIdentifier != null) {
            builder.append("serviceIdentifier=");
            builder.append(this.serviceIdentifier);
            builder.append(", ");
        }
        if (this.serviceProps != null) {
            builder.append("serviceProps=");
            Map<String, Object> maskedServiceProps = StringUtils.sha256MaskedMap(this.serviceProps, CollectionUtils.sensitiveNamesToMask(this.serviceProps.keySet()));
            builder.append(maskedServiceProps);
        }
        builder.append("}");
        return builder.toString();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getServiceIdentifier() {
        return this.serviceIdentifier;
    }

    public void setServiceIdentifier(String serviceIdentifier) {
        this.serviceIdentifier = serviceIdentifier;
    }

    @Override
    @JsonIgnore
    public Map<String, ?> getServiceProperties() {
        return this.getServiceProps();
    }

    @JsonGetter(value="serviceProperties")
    public Map<String, Object> getServiceProps() {
        return this.serviceProps;
    }

    @JsonSetter(value="serviceProperties")
    public void setServiceProps(Map<String, Object> serviceProps) {
        this.serviceProps = serviceProps;
    }
}

