/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.domain;

import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.solarnetwork.domain.Instruction;
import net.solarnetwork.domain.InstructionStatus;

public class BasicInstruction
implements Instruction,
Serializable {
    private static final long serialVersionUID = 5522509637377814131L;
    private final Long id;
    private final String topic;
    private final Instant instructionDate;
    private final InstructionStatus status;
    private final Map<String, List<String>> parameters;

    public BasicInstruction(Long id, String topic, Instant instructionDate, InstructionStatus status) {
        this.id = id;
        this.topic = topic;
        this.instructionDate = instructionDate;
        this.status = status;
        this.parameters = new LinkedHashMap<String, List<String>>();
    }

    public BasicInstruction(Instruction other, Long id, InstructionStatus status) {
        this(id != null ? id : other.getId(), other.getTopic(), other.getInstructionDate(), status != null ? status : other.getStatus());
        Map<String, List<String>> otherParams = other.getParameterMultiMap();
        if (otherParams != null) {
            this.parameters.putAll(otherParams);
        }
    }

    public BasicInstruction(Instruction other, InstructionStatus status) {
        this(other, null, status);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("BasicInstruction{topic=");
        builder.append(this.topic);
        builder.append(",id=");
        builder.append(this.id);
        builder.append(",status=");
        builder.append(this.status);
        builder.append("}");
        return builder.toString();
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public String getTopic() {
        return this.topic;
    }

    @Override
    public Instant getInstructionDate() {
        return this.instructionDate;
    }

    @Override
    public Iterable<String> getParameterNames() {
        return Collections.unmodifiableSet(this.parameters.keySet());
    }

    @Override
    public boolean isParameterAvailable(String parameterName) {
        List<String> values = this.parameters.get(parameterName);
        return values != null;
    }

    @Override
    public String getParameterValue(String parameterName) {
        List<String> values = this.parameters.get(parameterName);
        return values == null ? null : values.get(0);
    }

    @Override
    public String[] getAllParameterValues(String parameterName) {
        List<String> values = this.parameters.get(parameterName);
        if (values != null) {
            return values.toArray(new String[values.size()]);
        }
        return null;
    }

    @Override
    public InstructionStatus getStatus() {
        return this.status;
    }

    public void addParameter(String name, String value) {
        assert (name != null && value != null);
        List<String> values = this.parameters.get(name);
        if (values == null) {
            values = new ArrayList<String>(3);
            this.parameters.put(name, values);
        }
        values.add(value);
    }

    public void putParameters(String name, List<String> values) {
        assert (name != null && values != null);
        this.parameters.put(name, values);
    }

    @Override
    public Map<String, List<String>> getParameterMultiMap() {
        return Collections.unmodifiableMap(this.parameters);
    }
}

