/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.domain;

import java.io.Serializable;
import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import net.solarnetwork.domain.InstructionStatus;

public class BasicInstructionStatus
implements InstructionStatus,
Serializable {
    private static final long serialVersionUID = 5423487100585905801L;
    private final Long instructionId;
    private final InstructionStatus.InstructionState instructionState;
    private final Instant statusDate;
    private final Map<String, ?> resultParameters;

    public BasicInstructionStatus(Long instructionId, InstructionStatus.InstructionState instructionState, Instant statusDate) {
        this(instructionId, instructionState, statusDate, null);
    }

    public BasicInstructionStatus(Long instructionId, InstructionStatus.InstructionState instructionState, Instant statusDate, Map<String, ?> resultParameters) {
        this.instructionId = instructionId;
        this.instructionState = instructionState;
        this.statusDate = statusDate;
        this.resultParameters = resultParameters;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.instructionId, this.instructionState, this.resultParameters, this.statusDate});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BasicInstructionStatus other = (BasicInstructionStatus)obj;
        return Objects.equals(this.instructionId, other.instructionId) && this.instructionState == other.instructionState && Objects.equals(this.resultParameters, other.resultParameters) && Objects.equals(this.statusDate, other.statusDate);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("BasicInstructionStatus{");
        if (this.instructionId != null) {
            builder.append("instructionId=");
            builder.append(this.instructionId);
            builder.append(", ");
        }
        if (this.instructionState != null) {
            builder.append("instructionState=");
            builder.append((Object)this.instructionState);
            builder.append(", ");
        }
        if (this.statusDate != null) {
            builder.append("statusDate=");
            builder.append(this.statusDate);
            builder.append(", ");
        }
        if (this.resultParameters != null) {
            builder.append("resultParameters=");
            builder.append(this.resultParameters);
        }
        builder.append("}");
        return builder.toString();
    }

    @Override
    public InstructionStatus newCopyWithState(InstructionStatus.InstructionState newState, Map<String, ?> resultParameters) {
        return new BasicInstructionStatus(this.instructionId, newState, this.statusDate, resultParameters);
    }

    @Override
    public Long getInstructionId() {
        return this.instructionId;
    }

    @Override
    public InstructionStatus.InstructionState getInstructionState() {
        return this.instructionState;
    }

    @Override
    public Instant getStatusDate() {
        return this.statusDate;
    }

    @Override
    public Map<String, ?> getResultParameters() {
        return this.resultParameters;
    }
}

