/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.domain;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import net.solarnetwork.domain.NodeControlInfo;
import net.solarnetwork.domain.NodeControlPropertyType;

@JsonDeserialize(builder=Builder.class)
@JsonPropertyOrder(value={"controlId", "type", "propertyName", "value", "readonly", "unit"})
public class BasicNodeControlInfo
implements NodeControlInfo {
    private final String controlId;
    private final NodeControlPropertyType type;
    private final String value;
    private final Boolean readonly;
    private final String unit;
    private final String propertyName;

    public BasicNodeControlInfo(String controlId, NodeControlPropertyType type, String value, Boolean readonly, String unit, String propertyName) {
        this(BasicNodeControlInfo.builder().withControlId(controlId).withType(type).withValue(value).withReadonly(readonly).withUnit(unit).withPropertyName(propertyName));
    }

    private BasicNodeControlInfo(Builder builder) {
        this.controlId = builder.controlId;
        this.type = builder.type;
        this.value = builder.value;
        this.readonly = builder.readonly;
        this.unit = builder.unit;
        this.propertyName = builder.propertyName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builderFrom(NodeControlInfo info) {
        return new Builder(info);
    }

    @Override
    public String getControlId() {
        return this.controlId;
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public NodeControlPropertyType getType() {
        return this.type;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public Boolean getReadonly() {
        return this.readonly;
    }

    @Override
    public String getUnit() {
        return this.unit;
    }

    public static final class Builder {
        private String controlId;
        private NodeControlPropertyType type;
        private String value;
        private Boolean readonly;
        private String unit;
        private String propertyName;

        private Builder() {
        }

        private Builder(NodeControlInfo info) {
            this.controlId = info.getControlId();
            this.type = info.getType();
            this.value = info.getValue();
            this.readonly = info.getReadonly();
            this.unit = info.getUnit();
            this.propertyName = info.getPropertyName();
        }

        public Builder withControlId(String controlId) {
            this.controlId = controlId;
            return this;
        }

        public Builder withType(NodeControlPropertyType type) {
            this.type = type;
            return this;
        }

        public Builder withValue(String value) {
            this.value = value;
            return this;
        }

        public Builder withReadonly(Boolean readonly) {
            this.readonly = readonly;
            return this;
        }

        public Builder withUnit(String unit) {
            this.unit = unit;
            return this;
        }

        public Builder withPropertyName(String propertyName) {
            this.propertyName = propertyName;
            return this;
        }

        public BasicNodeControlInfo build() {
            return new BasicNodeControlInfo(this);
        }
    }
}

