/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.domain;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import net.solarnetwork.domain.RegistrationReceipt;

public class BasicRegistrationReceipt
implements RegistrationReceipt,
Cloneable {
    private static final long serialVersionUID = -8288922092122946581L;
    private String username;
    private String confirmationCode;

    public BasicRegistrationReceipt() {
        this(null, null);
    }

    public BasicRegistrationReceipt(String username, String confirmationCode) {
        this.username = username;
        this.confirmationCode = confirmationCode;
    }

    @Override
    public String getConfirmationCode() {
        return this.confirmationCode;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public String getUsernameURLComponent() {
        String result = this.getUsername();
        try {
            return result == null ? null : URLEncoder.encode(result, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Error encoding username for URL", e);
        }
    }

    protected Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.confirmationCode == null ? 0 : this.confirmationCode.hashCode());
        result = 31 * result + (this.username == null ? 0 : this.username.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BasicRegistrationReceipt other = (BasicRegistrationReceipt)obj;
        if (this.confirmationCode == null ? other.confirmationCode != null : !this.confirmationCode.equals(other.confirmationCode)) {
            return false;
        }
        return !(this.username == null ? other.username != null : !this.username.equals(other.username));
    }

    public String toString() {
        return "RegistrationReceipt{username=" + this.username + ",confirmationCode=" + this.confirmationCode + '}';
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setConfirmationCode(String confirmationCode) {
        this.confirmationCode = confirmationCode;
    }
}

