/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.domain;

public enum BitDataType {
    Bit(1, "bit", false, "Bit (on/off)"),
    Boolean("B", 1, false, "Boolean (true/false)"),
    Float32("f32", 4, true, "32-bit floating point (4 bytes)"),
    Float64("f64", 8, true, "64-bit floating point (8 bytes)"),
    Int8("i8", 1, true, "8-bit signed integer (1 byte)"),
    UInt8("u8", 1, "8-bit unsigned integer (1 byte)"),
    Int16("i16", 2, true, "16-bit signed integer (2 bytes)"),
    UInt16("u16", 2, "16-bit unsigned integer (2 bytes)"),
    Int32("i32", 4, true, "32-bit signed integer (4 bytes)"),
    UInt32("u32", 4, "32-bit unsigned integer (4 bytes)"),
    Int64("i64", 8, true, "64-bit signed integer (8 bytes)"),
    UInt64("u64", 8, "64-bit unsigned integer (8 bytes)"),
    Integer("I", -1, true, "Integer"),
    UnsignedInteger("U", -1, "Unsigned integer"),
    Bytes("b", -1, "Bytes", false),
    StringUtf8("s", -1, "String (ASCII)", false),
    StringAscii("a", -1, "String (UTF-8)", false);

    private final String key;
    private final int bitLength;
    private final int byteLength;
    private final boolean number;
    private final boolean signed;
    private final String description;

    private BitDataType(int bitLength, String key, boolean signed, String description) {
        this.key = key;
        this.bitLength = bitLength;
        this.byteLength = bitLength + (8 - bitLength % 8);
        this.number = true;
        this.signed = signed;
        this.description = description;
    }

    private BitDataType(String key, int byteLength, String description) {
        this(key, byteLength, false, description);
    }

    private BitDataType(String key, int byteLength, boolean signed, String description) {
        this.key = key;
        this.byteLength = byteLength;
        this.bitLength = byteLength * 8;
        this.number = true;
        this.signed = signed;
        this.description = description;
    }

    private BitDataType(String key, int byteLength, String description, boolean number) {
        this.key = key;
        this.bitLength = byteLength < 0 ? -1 : byteLength * 8;
        this.byteLength = byteLength;
        this.number = number;
        this.signed = false;
        this.description = description;
    }

    public String getKey() {
        return this.key;
    }

    public int getBitLength() {
        return this.bitLength;
    }

    public boolean isFractionalByteLength() {
        return this.bitLength % 8 != 0;
    }

    public int getByteLength() {
        return this.byteLength;
    }

    public boolean isNumber() {
        return this.number;
    }

    public boolean isSigned() {
        return this.signed;
    }

    public boolean isVariableLength() {
        return this.byteLength < 0;
    }

    public static BitDataType forKey(String key) {
        for (BitDataType e : BitDataType.values()) {
            if (!key.equals(e.key)) continue;
            return e;
        }
        throw new IllegalArgumentException("Unknown BitDataType key [" + key + "]");
    }

    public String getDescription() {
        return this.description;
    }
}

