/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.domain;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Collections;
import java.util.Set;
import net.solarnetwork.domain.Bitmaskable;
import net.solarnetwork.domain.DeviceOperatingState;
import net.solarnetwork.domain.GenericDeviceOperatingState;
import net.solarnetwork.domain.GenericDeviceOperatingStatus;

@JsonDeserialize(builder=Builder.class)
@JsonPropertyOrder(value={"state", "stateCode", "deviceStatesCode", "deviceStates"})
public class DeviceOperatingStatus<C extends Bitmaskable> {
    private final DeviceOperatingState state;
    private final Set<C> deviceStates;

    public DeviceOperatingStatus(DeviceOperatingState state) {
        this(state, null);
    }

    public DeviceOperatingStatus(DeviceOperatingState state, Set<C> deviceStates) {
        this.state = state != null ? state : DeviceOperatingState.Unknown;
        this.deviceStates = deviceStates == null || deviceStates.isEmpty() ? null : Collections.unmodifiableSet(deviceStates);
    }

    public DeviceOperatingState getState() {
        return this.state;
    }

    public int getStateCode() {
        return this.state.getCode();
    }

    public Set<C> getDeviceStates() {
        return this.deviceStates;
    }

    public int getDeviceStatesCode() {
        return Bitmaskable.bitmaskValue(this.deviceStates);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static <C extends Enum<C>> EnumBuilder<C> enumBuilder(Class<C> clazz) {
        return new EnumBuilder(clazz);
    }

    public static final class Builder {
        private DeviceOperatingState state;
        private Set<GenericDeviceOperatingState> deviceStates = Collections.emptySet();

        private Builder() {
        }

        public Builder withState(DeviceOperatingState state) {
            this.state = state;
            return this;
        }

        public Builder withStateCode(int code) {
            DeviceOperatingState state = null;
            try {
                state = DeviceOperatingState.forCode(code);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            return this.withState(state);
        }

        public Builder withDeviceStatesCode(int mask) {
            this.deviceStates = Bitmaskable.setForBitmask((int)mask, (Bitmaskable[])GenericDeviceOperatingState.values());
            return this;
        }

        public GenericDeviceOperatingStatus build() {
            return new GenericDeviceOperatingStatus(this.state, this.deviceStates);
        }
    }

    public static final class EnumBuilder<C extends Enum<C>> {
        private final Class<C> clazz;
        private DeviceOperatingState state;
        private Set<C> deviceStates = Collections.emptySet();

        private EnumBuilder(Class<C> clazz) {
            this.clazz = clazz;
        }

        public EnumBuilder<C> withState(DeviceOperatingState state) {
            this.state = state;
            return this;
        }

        public EnumBuilder<C> withStateCode(int code) {
            DeviceOperatingState state = null;
            try {
                state = DeviceOperatingState.forCode(code);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            return this.withState(state);
        }

        public EnumBuilder<C> withDeviceStatesCode(int mask) {
            this.deviceStates = Bitmaskable.setForBitmask(mask, this.clazz);
            return this;
        }

        public DeviceOperatingStatus<C> build() {
            return new DeviceOperatingStatus<C>(this.state, this.deviceStates);
        }
    }
}

