/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.domain;

import java.util.Collection;
import java.util.Iterator;

public interface Differentiable<T> {
    public boolean differsFrom(T var1);

    public static <T extends Differentiable<T>> boolean differ(T l, T r) {
        if (l == r) {
            return false;
        }
        if (l == null || r == null) {
            return true;
        }
        return l.differsFrom(r);
    }

    public static <T extends Differentiable<T>> boolean differ(Collection<T> l, Collection<T> r) {
        if (l == r) {
            return false;
        }
        if (l == null || r == null) {
            return true;
        }
        if (l.size() != r.size()) {
            return true;
        }
        Iterator<T> li = l.iterator();
        Iterator<T> ri = r.iterator();
        while (li.hasNext()) {
            Differentiable re;
            Differentiable le = (Differentiable)li.next();
            if (le == (re = (Differentiable)ri.next()) || le != null && re != null && !le.differsFrom(re)) continue;
            return true;
        }
        return false;
    }
}

