/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.domain;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.solarnetwork.domain.InstructionStatus;

public interface Instruction {
    public Long getId();

    public String getTopic();

    public Instant getInstructionDate();

    public Iterable<String> getParameterNames();

    public boolean isParameterAvailable(String var1);

    public String getParameterValue(String var1);

    public String[] getAllParameterValues(String var1);

    public InstructionStatus getStatus();

    default public InstructionStatus.InstructionState getInstructionState() {
        InstructionStatus status = this.getStatus();
        return status != null ? status.getInstructionState() : null;
    }

    default public Map<String, String> getParameterMap() {
        Map<String, String> result = null;
        for (String paramName : this.getParameterNames()) {
            if (result == null) {
                result = new LinkedHashMap<String, String>(4);
            }
            result.put(paramName, this.getParameterValue(paramName));
        }
        return result != null ? result : Collections.emptyMap();
    }

    default public Map<String, List<String>> getParameterMultiMap() {
        Map<String, List<String>> result = null;
        for (String paramName : this.getParameterNames()) {
            if (result == null) {
                result = new LinkedHashMap<String, List<String>>(4);
            }
            result.put(paramName, Arrays.asList(this.getAllParameterValues(paramName)));
        }
        return result != null ? result : Collections.emptyMap();
    }
}

