/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.domain;

import java.time.Instant;
import java.util.Map;
import net.solarnetwork.domain.BasicInstructionStatus;
import net.solarnetwork.domain.Instruction;

public interface InstructionStatus {
    public static final String MESSAGE_RESULT_PARAM = "message";
    public static final String ERROR_CODE_RESULT_PARAM = "code";

    public Long getInstructionId();

    public InstructionState getInstructionState();

    public Instant getStatusDate();

    public Map<String, ?> getResultParameters();

    default public InstructionStatus newCopyWithState(InstructionState newState) {
        return this.newCopyWithState(newState, null);
    }

    public InstructionStatus newCopyWithState(InstructionState var1, Map<String, ?> var2);

    public static InstructionStatus createStatus(Instruction instruction, InstructionState state, Instant date, Map<String, ?> resultParameters) {
        InstructionStatus status;
        InstructionStatus instructionStatus = status = instruction != null ? instruction.getStatus() : null;
        return status != null ? status.newCopyWithState(state, resultParameters) : new BasicInstructionStatus(instruction != null ? instruction.getId() : null, state, date != null ? date : Instant.now(), resultParameters);
    }

    public static enum InstructionState {
        Unknown,
        Queued,
        Queuing,
        Received,
        Executing,
        Declined,
        Completed;

    }
}

