/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.domain;

import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import net.solarnetwork.domain.Identity;

public interface LocalizedServiceInfo
extends Identity<String> {
    public static final Comparator<LocalizedServiceInfo> SORT_BY_NAME = new LocalizedNameComparator();

    public String getLocale();

    public String getLocalizedName();

    public String getLocalizedDescription();

    public Map<String, String> getLocalizedInfoMessages();

    public static class LocalizedNameComparator
    implements Comparator<LocalizedServiceInfo> {
        @Override
        public int compare(LocalizedServiceInfo o1, LocalizedServiceInfo o2) {
            String n2;
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            String n1 = o1.getLocalizedName();
            int result = Objects.compare(n1, n2 = o2.getLocalizedName(), String.CASE_INSENSITIVE_ORDER);
            if (result == 0) {
                result = o1.compareTo((String)o2.getId());
            }
            return 0;
        }
    }
}

