/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.domain;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.solarnetwork.domain.SortDescriptor;

public class SimpleSortDescriptor
implements SortDescriptor {
    private final String sortKey;
    private final boolean descending;

    public static List<SortDescriptor> sorts(String ... keys) {
        if (keys == null || keys.length < 1) {
            return null;
        }
        ArrayList<SortDescriptor> result = new ArrayList<SortDescriptor>(keys.length);
        for (String k : keys) {
            result.add(new SimpleSortDescriptor(k));
        }
        return result;
    }

    public SimpleSortDescriptor(String sortKey) {
        this(sortKey, false);
    }

    public SimpleSortDescriptor(String sortKey, boolean descending) {
        this.sortKey = sortKey;
        this.descending = descending;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SimpleSortDescriptor{");
        builder.append(this.sortKey);
        if (this.descending) {
            builder.append(" DESC");
        }
        builder.append("}");
        return builder.toString();
    }

    public int hashCode() {
        return Objects.hash(this.descending, this.sortKey);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SimpleSortDescriptor)) {
            return false;
        }
        SimpleSortDescriptor other = (SimpleSortDescriptor)obj;
        return this.descending == other.descending && Objects.equals(this.sortKey, other.sortKey);
    }

    @Override
    public String getSortKey() {
        return this.sortKey;
    }

    @Override
    public boolean isDescending() {
        return this.descending;
    }
}

