/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.domain.datum;

import net.solarnetwork.domain.AcPhase;
import net.solarnetwork.domain.datum.DatumSamplesType;
import net.solarnetwork.domain.datum.EnergyDatum;

public interface AcEnergyDatum
extends EnergyDatum {
    public static final String PHASE_KEY = "phase";
    public static final String REAL_POWER_KEY = "realPower";
    public static final String APPARENT_POWER_KEY = "apparentPower";
    public static final String REACTIVE_POWER_KEY = "reactivePower";
    public static final String POWER_FACTOR_KEY = "powerFactor";
    public static final String EFFECTIVE_POWER_FACTOR_KEY = "effectivePowerFactor";
    public static final String FREQUENCY_KEY = "frequency";
    public static final String VOLTAGE_KEY = "voltage";
    public static final String CURRENT_KEY = "current";
    public static final String PHASE_VOLTAGE_KEY = "phaseVoltage";
    public static final String LINE_VOLTAGE_KEY = "lineVoltage";
    public static final String NEUTRAL_CURRENT_KEY = "neutralCurrent";

    default public AcPhase getAcPhase() {
        String p = this.asSampleOperations().getSampleString(DatumSamplesType.Status, PHASE_KEY);
        return p == null ? null : AcPhase.valueOf(p);
    }

    default public Integer getRealPower() {
        return this.asSampleOperations().getSampleInteger(DatumSamplesType.Instantaneous, REAL_POWER_KEY);
    }

    default public Integer getApparentPower() {
        return this.asSampleOperations().getSampleInteger(DatumSamplesType.Instantaneous, APPARENT_POWER_KEY);
    }

    default public Integer getReactivePower() {
        return this.asSampleOperations().getSampleInteger(DatumSamplesType.Instantaneous, REACTIVE_POWER_KEY);
    }

    default public Float getEffectivePowerFactor() {
        return this.asSampleOperations().getSampleFloat(DatumSamplesType.Instantaneous, EFFECTIVE_POWER_FACTOR_KEY);
    }

    default public Float getFrequency() {
        return this.asSampleOperations().getSampleFloat(DatumSamplesType.Instantaneous, FREQUENCY_KEY);
    }

    default public Float getVoltage() {
        return this.asSampleOperations().getSampleFloat(DatumSamplesType.Instantaneous, VOLTAGE_KEY);
    }

    default public Float getVoltage(AcPhase phase) {
        return this.asSampleOperations().getSampleFloat(DatumSamplesType.Instantaneous, phase.withKey(VOLTAGE_KEY));
    }

    default public Float getCurrent() {
        return this.asSampleOperations().getSampleFloat(DatumSamplesType.Instantaneous, CURRENT_KEY);
    }

    default public Float getCurrent(AcPhase phase) {
        return this.asSampleOperations().getSampleFloat(DatumSamplesType.Instantaneous, phase.withKey(CURRENT_KEY));
    }

    default public Float getNeutralCurrent() {
        return this.asSampleOperations().getSampleFloat(DatumSamplesType.Instantaneous, NEUTRAL_CURRENT_KEY);
    }

    default public Float getPhaseVoltage() {
        return this.asSampleOperations().getSampleFloat(DatumSamplesType.Instantaneous, PHASE_VOLTAGE_KEY);
    }

    default public Float getLineVoltage() {
        return this.asSampleOperations().getSampleFloat(DatumSamplesType.Instantaneous, LINE_VOLTAGE_KEY);
    }

    default public Float getLineVoltage(AcPhase phase) {
        return this.asSampleOperations().getSampleFloat(DatumSamplesType.Instantaneous, phase.withLineKey(VOLTAGE_KEY));
    }

    default public Float getPowerFactor() {
        return this.asSampleOperations().getSampleFloat(DatumSamplesType.Instantaneous, POWER_FACTOR_KEY);
    }
}

