/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.domain.datum;

import java.math.BigDecimal;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.solarnetwork.domain.datum.AggregateDatumProperty;
import net.solarnetwork.domain.datum.DatumSamples;
import net.solarnetwork.domain.datum.DatumSamplesOperations;
import net.solarnetwork.domain.datum.DatumSamplesType;
import net.solarnetwork.domain.datum.DatumSupport;
import net.solarnetwork.util.NumberUtils;

public class AggregateDatumSamples
extends DatumSupport {
    private static final long serialVersionUID = -5462422979612352107L;
    private int count = 0;
    private Map<String, AggregateDatumProperty> instantaneous;
    private Map<String, AggregateDatumProperty> accumulating;
    private Map<String, Object> status;

    private void addAggregatePropertyValue(Map<String, AggregateDatumProperty> m, String key, Number n) {
        if (n == null) {
            m.remove(key);
        } else {
            m.compute(key, (k, v) -> {
                BigDecimal d = NumberUtils.bigDecimalForNumber(n);
                if (v != null) {
                    v.accumulate(d);
                    return v;
                }
                return new AggregateDatumProperty(d);
            });
        }
    }

    public void addSample(DatumSamplesOperations sample) {
        Set<String> t;
        if (sample == null) {
            return;
        }
        ++this.count;
        Map<String, ?> m = sample.getSampleData(DatumSamplesType.Instantaneous);
        if (m != null) {
            for (Map.Entry<String, ?> me : m.entrySet()) {
                this.putInstantaneousSampleValue(me.getKey(), (Number)me.getValue());
            }
        }
        if ((m = sample.getSampleData(DatumSamplesType.Accumulating)) != null) {
            for (Map.Entry<String, ?> me : m.entrySet()) {
                this.putAccumulatingSampleValue(me.getKey(), (Number)me.getValue());
            }
        }
        if ((m = sample.getSampleData(DatumSamplesType.Accumulating)) != null) {
            for (Map.Entry<String, ?> me : m.entrySet()) {
                this.putStatusSampleValue(me.getKey(), me.getValue());
            }
        }
        if ((t = sample.getTags()) != null) {
            for (String v : t) {
                this.addTag(v);
            }
        }
    }

    public DatumSamples average(int decimalScale, String minPropertyFormat, String maxPropertyFormat) {
        Set<String> set;
        Map<String, Object> map;
        Map<String, AggregateDatumProperty> a;
        DatumSamples out = new DatumSamples();
        Map<String, AggregateDatumProperty> i = this.getInstantaneous();
        if (i != null) {
            for (Map.Entry<String, AggregateDatumProperty> entry : i.entrySet()) {
                out.putInstantaneousSampleValue(entry.getKey(), entry.getValue().average(decimalScale));
                if (minPropertyFormat != null && !minPropertyFormat.isEmpty()) {
                    out.putInstantaneousSampleValue(String.format(minPropertyFormat, entry.getKey()), entry.getValue().getMin());
                }
                if (maxPropertyFormat == null || maxPropertyFormat.isEmpty()) continue;
                out.putInstantaneousSampleValue(String.format(maxPropertyFormat, entry.getKey()), entry.getValue().getMax());
            }
        }
        if ((a = this.getAccumulating()) != null) {
            for (Map.Entry<String, AggregateDatumProperty> entry : a.entrySet()) {
                out.putAccumulatingSampleValue(entry.getKey(), entry.getValue().last());
            }
        }
        if ((map = this.getStatus()) != null) {
            out.setStatus(map);
        }
        if ((set = this.getTags()) != null) {
            out.setTags(set);
        }
        return out;
    }

    public int addedSampleCount() {
        return this.count;
    }

    public void putInstantaneousSampleValue(String key, Number n) {
        Map<String, AggregateDatumProperty> m = this.instantaneous;
        if (m == null) {
            if (n == null) {
                return;
            }
            this.instantaneous = m = new LinkedHashMap<String, AggregateDatumProperty>(4);
        }
        this.addAggregatePropertyValue(m, key, n);
    }

    public void putAccumulatingSampleValue(String key, Number n) {
        Map<String, AggregateDatumProperty> m = this.accumulating;
        if (m == null) {
            if (n == null) {
                return;
            }
            this.accumulating = m = new LinkedHashMap<String, AggregateDatumProperty>(4);
        }
        this.addAggregatePropertyValue(m, key, n);
    }

    public void putStatusSampleValue(String key, Object value) {
        Map<String, Object> m = this.status;
        if (m == null) {
            if (value == null) {
                return;
            }
            this.status = m = new LinkedHashMap<String, Object>(4);
        }
        if (value == null) {
            m.remove(key);
        } else {
            m.put(key, value);
        }
    }

    public Map<String, AggregateDatumProperty> getInstantaneous() {
        return this.instantaneous;
    }

    public Map<String, AggregateDatumProperty> getAccumulating() {
        return this.accumulating;
    }

    public Map<String, Object> getStatus() {
        return this.status;
    }
}

