/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.domain.datum;

public enum Aggregation {
    None(0, "0"),
    Minute(60, "m"),
    FiveMinute(300, "5m"),
    TenMinute(600, "10m"),
    FifteenMinute(900, "15m"),
    ThirtyMinute(1800, "30m"),
    Hour(3600, "h"),
    HourOfDay(3600, "hd"),
    SeasonalHourOfDay(3600, "shd"),
    Day(86400, "d"),
    DayOfWeek(86400, "wd"),
    SeasonalDayOfWeek(86400, "swd"),
    Week(604800, "w"),
    WeekOfYear(604800, "yw"),
    Month(2419200, "M"),
    Year(31536000, "y"),
    RunningTotal(Integer.MAX_VALUE, "rt");

    private final Integer level;
    private final String key;

    private Aggregation(int level, String key) {
        this.level = level;
        this.key = key;
    }

    public int compareLevel(Aggregation other) {
        return this.level.compareTo(other.level);
    }

    public Integer getLevel() {
        return this.level;
    }

    public String getKey() {
        return this.key;
    }

    public static Aggregation forKey(String key) {
        if (key == null || key.isEmpty()) {
            return None;
        }
        try {
            return Aggregation.valueOf(key);
        }
        catch (IllegalArgumentException e) {
            for (Aggregation a : Aggregation.values()) {
                if (!a.key.equals(key)) continue;
                return a;
            }
            throw new IllegalArgumentException("Invalid Aggregation value [" + key + "]");
        }
    }
}

