/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.domain.datum;

import java.math.BigDecimal;
import net.solarnetwork.domain.datum.Datum;
import net.solarnetwork.domain.datum.DatumSamplesType;

public interface AtmosphericDatum
extends Datum {
    public static final String CO2_KEY = "co2";
    public static final String LUX_KEY = "lux";
    public static final String TEMPERATURE_KEY = "temp";
    public static final String HUMIDITY_KEY = "humidity";
    public static final String DEW_POINT_KEY = "dew";
    public static final String ATMOSPHERIC_PRESSURE_KEY = "atm";
    public static final String VISIBILITY_KEY = "visibility";
    public static final String SKY_CONDITIONS_KEY = "sky";
    public static final String SKY_CONDITION_CODES_KEY = "skies";
    public static final String WIND_SPEED_KEY = "wspeed";
    public static final String WIND_DIRECTION_KEY = "wdir";
    public static final String RAIN_KEY = "rain";
    public static final String SNOW_KEY = "snow";
    public static final String IRRADIANCE_KEY = "irradiance";
    public static final String TAG_ATMOSPHERE_INDOOR = "indoor";
    public static final String TAG_ATMOSPHERE_OUTDOOR = "outdoor";
    public static final String TAG_FORECAST = "forecast";

    default public BigDecimal getCO2() {
        return this.asSampleOperations().getSampleBigDecimal(DatumSamplesType.Instantaneous, CO2_KEY);
    }

    default public BigDecimal getLux() {
        return this.asSampleOperations().getSampleBigDecimal(DatumSamplesType.Instantaneous, LUX_KEY);
    }

    default public BigDecimal getTemperature() {
        return this.asSampleOperations().getSampleBigDecimal(DatumSamplesType.Instantaneous, TEMPERATURE_KEY);
    }

    default public BigDecimal getDewPoint() {
        return this.asSampleOperations().getSampleBigDecimal(DatumSamplesType.Instantaneous, DEW_POINT_KEY);
    }

    default public Integer getHumidity() {
        return this.asSampleOperations().getSampleInteger(DatumSamplesType.Instantaneous, HUMIDITY_KEY);
    }

    default public Integer getAtmosphericPressure() {
        return this.asSampleOperations().getSampleInteger(DatumSamplesType.Instantaneous, ATMOSPHERIC_PRESSURE_KEY);
    }

    default public Integer getVisibility() {
        return this.asSampleOperations().getSampleInteger(DatumSamplesType.Instantaneous, VISIBILITY_KEY);
    }

    default public String getSkyConditions() {
        return this.asSampleOperations().getSampleString(DatumSamplesType.Status, SKY_CONDITIONS_KEY);
    }

    default public BigDecimal getWindSpeed() {
        return this.asSampleOperations().getSampleBigDecimal(DatumSamplesType.Instantaneous, WIND_SPEED_KEY);
    }

    default public Integer getWindDirection() {
        return this.asSampleOperations().getSampleInteger(DatumSamplesType.Instantaneous, WIND_DIRECTION_KEY);
    }

    default public Integer getRain() {
        return this.asSampleOperations().getSampleInteger(DatumSamplesType.Instantaneous, RAIN_KEY);
    }

    default public Integer getSnow() {
        return this.asSampleOperations().getSampleInteger(DatumSamplesType.Instantaneous, SNOW_KEY);
    }

    default public BigDecimal getIrradiance() {
        return this.asSampleOperations().getSampleBigDecimal(DatumSamplesType.Instantaneous, IRRADIANCE_KEY);
    }
}

