/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.domain.datum;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import java.util.UUID;
import net.solarnetwork.domain.datum.DatumSamplesType;
import net.solarnetwork.domain.datum.DatumStreamMetadata;

public class BasicDatumStreamMetadata
implements DatumStreamMetadata,
Serializable {
    private static final long serialVersionUID = -6339837836211488890L;
    private final UUID streamId;
    private final String timeZoneId;
    private final String[] instantaneousProperties;
    private final String[] accumulatingProperties;
    private final String[] statusProperties;

    public BasicDatumStreamMetadata(UUID streamId, String timeZoneId, String[] instantaneousProperties, String[] accumulatingProperties, String[] statusProperties) {
        if (streamId == null) {
            throw new IllegalArgumentException("The streamId argument must not be null.");
        }
        this.streamId = streamId;
        this.timeZoneId = timeZoneId;
        this.instantaneousProperties = instantaneousProperties != null && instantaneousProperties.length > 0 ? instantaneousProperties : null;
        this.accumulatingProperties = accumulatingProperties != null && accumulatingProperties.length > 0 ? accumulatingProperties : null;
        this.statusProperties = statusProperties != null && statusProperties.length > 0 ? statusProperties : null;
    }

    public BasicDatumStreamMetadata(UUID streamId, String timeZoneId, Object instantaneousProperties, Object accumulatingProperties, Object statusProperties) {
        this(streamId, timeZoneId, (String[])instantaneousProperties, (String[])accumulatingProperties, (String[])statusProperties);
    }

    @Override
    public UUID getStreamId() {
        return this.streamId;
    }

    @Override
    public String getTimeZoneId() {
        return this.timeZoneId;
    }

    public int getPropertyNamesLength() {
        return this.getInstantaneousLength() + this.getAccumulatingLength() + this.getStatusLength();
    }

    @Override
    public String[] getPropertyNames() {
        int sLen;
        int aLen;
        int iLen = this.getInstantaneousLength();
        int len = iLen + (aLen = this.getAccumulatingLength()) + (sLen = this.getStatusLength());
        if (len < 1) {
            return null;
        }
        String[] result = new String[len];
        if (iLen > 0) {
            System.arraycopy(this.instantaneousProperties, 0, result, 0, iLen);
        }
        if (aLen > 0) {
            System.arraycopy(this.accumulatingProperties, 0, result, iLen, aLen);
        }
        if (sLen > 0) {
            System.arraycopy(this.statusProperties, 0, result, iLen + aLen, sLen);
        }
        return result;
    }

    @Override
    public String[] propertyNamesForType(DatumSamplesType type) {
        if (type == null) {
            return null;
        }
        switch (type) {
            case Instantaneous: {
                return this.instantaneousProperties;
            }
            case Accumulating: {
                return this.accumulatingProperties;
            }
            case Status: {
                return this.statusProperties;
            }
        }
        return null;
    }

    public int getInstantaneousLength() {
        return this.instantaneousProperties != null ? this.instantaneousProperties.length : 0;
    }

    public int getAccumulatingLength() {
        return this.accumulatingProperties != null ? this.accumulatingProperties.length : 0;
    }

    public int getStatusLength() {
        return this.statusProperties != null ? this.statusProperties.length : 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.accumulatingProperties);
        result = 31 * result + Arrays.hashCode(this.instantaneousProperties);
        result = 31 * result + Arrays.hashCode(this.statusProperties);
        result = 31 * result + Objects.hash(this.streamId, this.timeZoneId);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BasicDatumStreamMetadata)) {
            return false;
        }
        BasicDatumStreamMetadata other = (BasicDatumStreamMetadata)obj;
        return Arrays.equals(this.accumulatingProperties, other.accumulatingProperties) && Arrays.equals(this.instantaneousProperties, other.instantaneousProperties) && Arrays.equals(this.statusProperties, other.statusProperties) && Objects.equals(this.streamId, other.streamId) && Objects.equals(this.timeZoneId, other.timeZoneId);
    }
}

