/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.domain.datum;

import java.util.Collection;
import java.util.Iterator;
import java.util.UUID;
import net.solarnetwork.domain.datum.ObjectDatumStreamDataSet;
import net.solarnetwork.domain.datum.ObjectDatumStreamMetadata;
import net.solarnetwork.domain.datum.ObjectDatumStreamMetadataProvider;
import net.solarnetwork.domain.datum.StreamDatum;
import net.solarnetwork.util.ObjectUtils;

public class BasicObjectDatumStreamDataSet<T extends StreamDatum>
implements ObjectDatumStreamDataSet<T> {
    private final ObjectDatumStreamMetadataProvider provider;
    private final Iterable<T> data;
    private final Long totalResultCount;
    private final Integer returnedResultCount;
    private final Integer startingOffset;

    public static final <T extends StreamDatum> BasicObjectDatumStreamDataSet<T> dataSet(Iterable<ObjectDatumStreamMetadata> metadatas, Iterable<T> data) {
        return BasicObjectDatumStreamDataSet.dataSet(metadatas, data, null, null, null);
    }

    public static final <T extends StreamDatum> BasicObjectDatumStreamDataSet<T> dataSet(Iterable<ObjectDatumStreamMetadata> metadatas, Iterable<T> data, Long totalResultCount, Integer startingOffset, Integer returnedResultCount) {
        return new BasicObjectDatumStreamDataSet<T>(ObjectDatumStreamMetadataProvider.staticProvider(metadatas), data, totalResultCount, startingOffset, returnedResultCount);
    }

    public BasicObjectDatumStreamDataSet(ObjectDatumStreamMetadataProvider provider, Iterable<T> data) {
        this(provider, data, null, null, null);
    }

    public BasicObjectDatumStreamDataSet(ObjectDatumStreamMetadataProvider provider, Iterable<T> data, Long totalResultCount, Integer startingOffset, Integer returnedResultCount) {
        this.provider = ObjectUtils.requireNonNullArgument(provider, "provider");
        this.data = ObjectUtils.requireNonNullArgument(data, "data");
        this.totalResultCount = totalResultCount;
        this.startingOffset = startingOffset;
        this.returnedResultCount = returnedResultCount;
    }

    @Override
    public Collection<UUID> metadataStreamIds() {
        return this.provider.metadataStreamIds();
    }

    @Override
    public ObjectDatumStreamMetadata metadataForStreamId(UUID streamId) {
        return this.provider.metadataForStreamId(streamId);
    }

    @Override
    public ObjectDatumStreamMetadata metadataForObjectSource(Long objectId, String sourceId) {
        return this.provider.metadataForObjectSource(objectId, sourceId);
    }

    @Override
    public Iterator<T> iterator() {
        return this.data.iterator();
    }

    @Override
    public Iterable<T> getResults() {
        return this.data;
    }

    @Override
    public Long getTotalResultCount() {
        return this.totalResultCount;
    }

    @Override
    public Integer getStartingOffset() {
        return this.startingOffset;
    }

    @Override
    public Integer getReturnedResultCount() {
        return this.returnedResultCount;
    }
}

