/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.domain.datum;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Objects;
import java.util.UUID;
import net.solarnetwork.domain.datum.DatumProperties;
import net.solarnetwork.domain.datum.StreamDatum;
import net.solarnetwork.util.ObjectUtils;

public class BasicStreamDatum
implements StreamDatum,
Cloneable,
Serializable {
    private static final long serialVersionUID = -8735056339943547310L;
    private final UUID streamId;
    private final Instant timestamp;
    private final DatumProperties properties;

    public BasicStreamDatum(UUID streamId, Instant timestamp, DatumProperties properties) {
        this.streamId = ObjectUtils.requireNonNullArgument(streamId, "streamId");
        this.timestamp = ObjectUtils.requireNonNullArgument(timestamp, "timestamp");
        this.properties = properties;
    }

    public BasicStreamDatum clone() {
        try {
            return (BasicStreamDatum)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("BasicStreamDatum{streamId=");
        builder.append(this.streamId);
        builder.append(", ts=");
        builder.append(this.timestamp);
        if (this.properties != null) {
            if (this.properties.getInstantaneous() != null) {
                builder.append(", i=");
                builder.append(Arrays.toString(this.properties.getInstantaneous()));
            }
            if (this.properties.getAccumulating() != null) {
                builder.append(", a=");
                builder.append(Arrays.toString(this.properties.getAccumulating()));
            }
            if (this.properties.getStatus() != null) {
                builder.append(", s=");
                builder.append(Arrays.toString(this.properties.getStatus()));
            }
            if (this.properties.getTags() != null) {
                builder.append(", t=");
                builder.append(Arrays.toString(this.properties.getTags()));
            }
        }
        builder.append("}");
        return builder.toString();
    }

    public int hashCode() {
        return Objects.hash(this.properties, this.streamId, this.timestamp);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BasicStreamDatum)) {
            return false;
        }
        BasicStreamDatum other = (BasicStreamDatum)obj;
        return Objects.equals(this.properties, other.properties) && Objects.equals(this.streamId, other.streamId) && Objects.equals(this.timestamp, other.timestamp);
    }

    @Override
    public Instant getTimestamp() {
        return this.timestamp;
    }

    @Override
    public UUID getStreamId() {
        return this.streamId;
    }

    @Override
    public DatumProperties getProperties() {
        return this.properties;
    }
}

