/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.domain.datum;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import net.solarnetwork.domain.Differentiable;
import net.solarnetwork.util.CollectionUtils;

public interface DatumMetadataOperations
extends Differentiable<DatumMetadataOperations> {
    default public Set<String> getInfoKeys() {
        Map<String, ?> info = this.getInfo();
        return info != null ? info.keySet() : Collections.emptySet();
    }

    public Map<String, ?> getInfo();

    default public Object getInfo(String key) {
        Map<String, ?> info = this.getInfo();
        return info != null ? info.get(key) : null;
    }

    default public boolean hasInfo(String key) {
        Map<String, ?> info = this.getInfo();
        return info != null ? info.containsKey(key) : false;
    }

    public Set<String> getPropertyInfoKeys();

    public Map<String, ?> getPropertyInfo(String var1);

    default public boolean hasPropertyInfo(String key) {
        Map<String, ?> info = this.getPropertyInfo(key);
        return info != null;
    }

    default public boolean hasInfo(String property, String key) {
        Map<String, ?> info = this.getPropertyInfo(property);
        return info != null ? info.containsKey(key) : false;
    }

    public Set<String> getTags();

    default public boolean hasTag(String tag) {
        Set<String> tags = this.getTags();
        return tags != null && tags.contains(tag);
    }

    default public boolean isEmpty() {
        Set<String> keys = this.getInfoKeys();
        if (keys != null && !keys.isEmpty()) {
            return false;
        }
        keys = this.getPropertyInfoKeys();
        if (keys != null) {
            for (String key : keys) {
                Map<String, ?> propInfo = this.getPropertyInfo(key);
                if (propInfo == null || propInfo.isEmpty()) continue;
                return false;
            }
        }
        return (keys = this.getTags()) == null || keys.isEmpty();
    }

    @Override
    default public boolean differsFrom(DatumMetadataOperations other) {
        if (other == null) {
            return true;
        }
        if (this == other) {
            return false;
        }
        Map<String, ?> i1 = this.getInfo();
        Map<String, ?> i2 = other.getInfo();
        if (i1 == null ? i2 != null : !i1.equals(i2)) {
            return true;
        }
        Set<String> keys = this.getPropertyInfoKeys();
        if (keys != null && !keys.isEmpty()) {
            for (String key : keys) {
                i1 = this.getPropertyInfo(key);
                i2 = other.getPropertyInfo(key);
                if (!(i1 == null ? i2 != null : !i1.equals(i2))) continue;
                return true;
            }
        }
        return this.getTags() == null ? other.getTags() != null : !this.getTags().equals(other.getTags());
    }

    default public boolean hasMetadataAtPath(String path) {
        return this.metadataAtPath(path) != null;
    }

    public Object metadataAtPath(String var1);

    public <T> T metadataAtPath(String var1, Class<T> var2);

    default public Number getInfoNumber(String key) {
        Object v;
        Map<String, ?> info = this.getInfo();
        Object object = v = info != null ? (Object)info.get(key) : null;
        if (v == null) {
            return null;
        }
        if (v instanceof Number) {
            return (Number)v;
        }
        try {
            return new BigDecimal(v.toString());
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    default public Short getInfoShort(String key) {
        return CollectionUtils.getMapShort(key, this.getInfo());
    }

    default public Integer getInfoInteger(String key) {
        return CollectionUtils.getMapInteger(key, this.getInfo());
    }

    default public Long getInfoLong(String key) {
        return CollectionUtils.getMapLong(key, this.getInfo());
    }

    default public Float getInfoFloat(String key) {
        return CollectionUtils.getMapFloat(key, this.getInfo());
    }

    default public Double getInfoDouble(String key) {
        return CollectionUtils.getMapDouble(key, this.getInfo());
    }

    default public BigDecimal getInfoBigDecimal(String key) {
        return CollectionUtils.getMapBigDecimal(key, this.getInfo());
    }

    default public BigInteger getInfoBigInteger(String key) {
        return CollectionUtils.getMapBigInteger(key, this.getInfo());
    }

    default public String getInfoString(String key) {
        return CollectionUtils.getMapString(key, this.getInfo());
    }

    default public Number getInfoNumber(String property, String key) {
        Object v;
        Map<String, ?> info = this.getPropertyInfo(property);
        Object object = v = info != null ? (Object)info.get(key) : null;
        if (v == null) {
            return null;
        }
        if (v instanceof Number) {
            return (Number)v;
        }
        try {
            return new BigDecimal(v.toString());
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    default public Short getInfoShort(String property, String key) {
        return CollectionUtils.getMapShort(key, this.getPropertyInfo(property));
    }

    default public Integer getInfoInteger(String property, String key) {
        return CollectionUtils.getMapInteger(key, this.getPropertyInfo(property));
    }

    default public Long getInfoLong(String property, String key) {
        return CollectionUtils.getMapLong(key, this.getPropertyInfo(property));
    }

    default public Float getInfoFloat(String property, String key) {
        return CollectionUtils.getMapFloat(key, this.getPropertyInfo(property));
    }

    default public Double getInfoDouble(String property, String key) {
        return CollectionUtils.getMapDouble(key, this.getPropertyInfo(property));
    }

    default public BigDecimal getInfoBigDecimal(String property, String key) {
        return CollectionUtils.getMapBigDecimal(key, this.getPropertyInfo(property));
    }

    default public BigInteger getInfoBigInteger(String property, String key) {
        return CollectionUtils.getMapBigInteger(key, this.getPropertyInfo(property));
    }

    default public String getInfoString(String property, String key) {
        return CollectionUtils.getMapString(key, this.getPropertyInfo(property));
    }
}

