/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.domain.datum;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.solarnetwork.domain.datum.Datum;
import net.solarnetwork.domain.datum.DatumSamplesOperations;
import net.solarnetwork.domain.datum.DatumSamplesType;
import net.solarnetwork.domain.datum.ObjectDatumStreamMetadata;

public class DatumProperties
implements Serializable {
    private static final long serialVersionUID = -2647856276610023629L;
    private BigDecimal[] instantaneous;
    private BigDecimal[] accumulating;
    private String[] status;
    private String[] tags;

    public static DatumProperties propertiesOf(BigDecimal[] instantaneous, BigDecimal[] accumulating, String[] status, String[] tags) {
        DatumProperties s = new DatumProperties();
        s.instantaneous = instantaneous;
        s.accumulating = accumulating;
        s.status = status;
        s.tags = tags;
        return s;
    }

    public static DatumProperties propertiesFrom(Datum datum, ObjectDatumStreamMetadata meta) throws IllegalArgumentException {
        if (datum == null) {
            return null;
        }
        if (meta == null) {
            throw new IllegalArgumentException("No stream metadata available for datum " + datum);
        }
        DatumSamplesOperations ops = datum.asSampleOperations();
        if (ops == null) {
            return null;
        }
        BigDecimal[] data_i = DatumProperties.decimalPropertiesFrom(meta, ops, DatumSamplesType.Instantaneous);
        BigDecimal[] data_a = DatumProperties.decimalPropertiesFrom(meta, ops, DatumSamplesType.Accumulating);
        String[] data_s = DatumProperties.stringPropertiesFrom(meta, ops, DatumSamplesType.Status);
        Set<String> tags = ops.getTags();
        String[] data_t = tags != null && !tags.isEmpty() ? tags.toArray(new String[tags.size()]) : null;
        return DatumProperties.propertiesOf(data_i, data_a, data_s, data_t);
    }

    private static BigDecimal[] decimalPropertiesFrom(ObjectDatumStreamMetadata meta, DatumSamplesOperations ops, DatumSamplesType type) {
        String[] propNames = meta.propertyNamesForType(type);
        int len = propNames != null ? propNames.length : 0;
        BigDecimal[] data = null;
        Map<String, ?> map = ops.getSampleData(type);
        if (len < 1) {
            if (map != null && !map.isEmpty()) {
                throw new IllegalArgumentException("Datum stream unknown " + (Object)((Object)type) + " properties encountered: " + map.keySet());
            }
        } else if (map != null && !map.isEmpty()) {
            HashSet<String> props = new HashSet<String>(map.keySet());
            data = new BigDecimal[propNames.length];
            int nonNullLength = 0;
            for (int i = 0; i < len; ++i) {
                BigDecimal n = ops.getSampleBigDecimal(type, propNames[i]);
                if (n != null) {
                    data[i] = n;
                    nonNullLength = i + 1;
                }
                props.remove(propNames[i]);
            }
            if (!props.isEmpty()) {
                throw new IllegalArgumentException("Datum stream unknown " + (Object)((Object)type) + " properties encountered: " + props);
            }
            if (nonNullLength < len) {
                BigDecimal[] trimmedData = new BigDecimal[nonNullLength];
                System.arraycopy(data, 0, trimmedData, 0, nonNullLength);
                data = trimmedData;
            }
        }
        return data;
    }

    private static String[] stringPropertiesFrom(ObjectDatumStreamMetadata meta, DatumSamplesOperations ops, DatumSamplesType type) {
        String[] propNames = meta.propertyNamesForType(type);
        int len = propNames != null ? propNames.length : 0;
        String[] data = null;
        Map<String, ?> map = ops.getSampleData(type);
        if (len < 1) {
            if (map != null && !map.isEmpty()) {
                throw new IllegalArgumentException("Datum stream unknown " + (Object)((Object)type) + " properties encountered: " + map.keySet());
            }
        } else if (map != null && !map.isEmpty()) {
            HashSet<String> props = new HashSet<String>(map.keySet());
            data = new String[propNames.length];
            int nonNullLength = 0;
            for (int i = 0; i < len; ++i) {
                String s = ops.getSampleString(type, propNames[i]);
                if (s != null) {
                    data[i] = s;
                    nonNullLength = i + 1;
                }
                props.remove(propNames[i]);
            }
            if (!props.isEmpty()) {
                throw new IllegalArgumentException("Datum stream unknown " + (Object)((Object)type) + " properties encountered: " + props);
            }
            if (nonNullLength < len) {
                String[] trimmedData = new String[nonNullLength];
                System.arraycopy(data, 0, trimmedData, 0, nonNullLength);
                data = trimmedData;
            }
        }
        return data;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.accumulating);
        result = 31 * result + Arrays.hashCode(this.instantaneous);
        result = 31 * result + Arrays.hashCode(this.status);
        result = 31 * result + Arrays.hashCode(this.tags);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DatumProperties)) {
            return false;
        }
        DatumProperties other = (DatumProperties)obj;
        return Arrays.equals(this.accumulating, other.accumulating) && Arrays.equals(this.instantaneous, other.instantaneous) && Arrays.equals(this.status, other.status) && Arrays.equals(this.tags, other.tags);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DatumProperties{");
        if (this.instantaneous != null) {
            builder.append("instantaneous=");
            builder.append(Arrays.toString(this.instantaneous));
            builder.append(", ");
        }
        if (this.accumulating != null) {
            builder.append("accumulating=");
            builder.append(Arrays.toString(this.accumulating));
            builder.append(", ");
        }
        if (this.status != null) {
            builder.append("status=");
            builder.append(Arrays.toString(this.status));
            builder.append(", ");
        }
        if (this.tags != null) {
            builder.append("tags=");
            builder.append(Arrays.toString(this.tags));
        }
        builder.append("}");
        return builder.toString();
    }

    public int getLength() {
        return this.getInstantaneousLength() + this.getAccumulatingLength() + this.getStatusLength() + this.getTagsLength();
    }

    public int getInstantaneousLength() {
        BigDecimal[] array = this.getInstantaneous();
        return array != null ? array.length : 0;
    }

    public BigDecimal[] getInstantaneous() {
        return this.instantaneous;
    }

    public void setInstantaneous(BigDecimal[] values) {
        this.instantaneous = values;
    }

    public BigDecimal instantaneousValue(int index) {
        BigDecimal[] values = this.getInstantaneous();
        if (values != null && index < values.length) {
            return values[index];
        }
        return null;
    }

    public int getAccumulatingLength() {
        BigDecimal[] array = this.getAccumulating();
        return array != null ? array.length : 0;
    }

    public BigDecimal[] getAccumulating() {
        return this.accumulating;
    }

    public void setAccumulating(BigDecimal[] values) {
        this.accumulating = values;
    }

    public BigDecimal accumulatingValue(int index) {
        BigDecimal[] values = this.getAccumulating();
        if (values != null && index < values.length) {
            return values[index];
        }
        return null;
    }

    public int getStatusLength() {
        String[] array = this.getStatus();
        return array != null ? array.length : 0;
    }

    public String[] getStatus() {
        return this.status;
    }

    public void setStatus(String[] status) {
        this.status = status;
    }

    public String statusValue(int index) {
        String[] values = this.getStatus();
        if (values != null && index < values.length) {
            return values[index];
        }
        return null;
    }

    public int getTagsLength() {
        String[] array = this.getTags();
        return array != null ? array.length : 0;
    }

    public String[] getTags() {
        return this.tags;
    }

    public void setTags(String[] tags) {
        this.tags = tags;
    }

    public boolean hasTag(String tag) {
        String[] tags = this.getTags();
        if (tags != null) {
            int len = tags.length;
            for (int i = 0; i < len; ++i) {
                if (!tag.equalsIgnoreCase(tags[i])) continue;
                return true;
            }
        }
        return false;
    }
}

