/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.domain.datum;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;

public class DatumPropertiesStatistics
implements Serializable {
    private static final long serialVersionUID = -1933887645480711417L;
    private BigDecimal[][] instantaneous;
    private BigDecimal[][] accumulating;

    public static DatumPropertiesStatistics statisticsOf(BigDecimal[][] instantaneous, BigDecimal[][] accumulating) {
        DatumPropertiesStatistics s = new DatumPropertiesStatistics();
        s.instantaneous = instantaneous;
        s.accumulating = accumulating;
        return s;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DatumPropertiesStatistics{");
        if (this.instantaneous != null) {
            builder.append("i=");
            builder.append(Arrays.deepToString((Object[])this.instantaneous));
            builder.append("], ");
        }
        if (this.accumulating != null) {
            builder.append("a=");
            builder.append(Arrays.deepToString((Object[])this.accumulating));
        }
        builder.append("}");
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.deepHashCode((Object[])this.accumulating);
        result = 31 * result + Arrays.deepHashCode((Object[])this.instantaneous);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DatumPropertiesStatistics)) {
            return false;
        }
        DatumPropertiesStatistics other = (DatumPropertiesStatistics)obj;
        return Arrays.deepEquals((Object[])this.accumulating, (Object[])other.accumulating) && Arrays.deepEquals((Object[])this.instantaneous, (Object[])other.instantaneous);
    }

    public int getLength() {
        return this.getInstantaneousLength() + this.getAccumulatingLength();
    }

    public int getInstantaneousLength() {
        BigDecimal[][] array = this.getInstantaneous();
        return array != null ? array.length : 0;
    }

    public BigDecimal[][] getInstantaneous() {
        return this.instantaneous;
    }

    public void setInstantaneous(BigDecimal[][] instantaneous) {
        this.instantaneous = instantaneous;
    }

    private static BigDecimal getStat(BigDecimal[][] array, int propertyIndex, int statIndex) {
        if (array == null || propertyIndex >= array.length) {
            return null;
        }
        BigDecimal[] stats = array[propertyIndex];
        if (stats == null || statIndex >= stats.length) {
            return null;
        }
        return stats[statIndex];
    }

    public BigDecimal getInstantaneousCount(int propertyIndex) {
        return DatumPropertiesStatistics.getStat(this.getInstantaneous(), propertyIndex, InstantaneousStatistic.Count.ordinal());
    }

    public BigDecimal getInstantaneousMinimum(int propertyIndex) {
        return DatumPropertiesStatistics.getStat(this.getInstantaneous(), propertyIndex, InstantaneousStatistic.Minimum.ordinal());
    }

    public BigDecimal getInstantaneousMaximum(int propertyIndex) {
        return DatumPropertiesStatistics.getStat(this.getInstantaneous(), propertyIndex, InstantaneousStatistic.Maximum.ordinal());
    }

    public BigDecimal getAccumulatingStart(int propertyIndex) {
        return DatumPropertiesStatistics.getStat(this.getAccumulating(), propertyIndex, AccumulatingStatistic.Start.ordinal());
    }

    public BigDecimal getAccumulatingEnd(int propertyIndex) {
        return DatumPropertiesStatistics.getStat(this.getAccumulating(), propertyIndex, AccumulatingStatistic.End.ordinal());
    }

    public int getAccumulatingLength() {
        BigDecimal[][] array = this.getAccumulating();
        return array != null ? array.length : 0;
    }

    public BigDecimal[][] getAccumulating() {
        return this.accumulating;
    }

    public void setAccumulating(BigDecimal[][] accumulating) {
        this.accumulating = accumulating;
    }

    public static enum InstantaneousStatistic {
        Count,
        Minimum,
        Maximum;

    }

    public static enum AccumulatingStatistic {
        Start,
        End;

    }
}

