/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.domain.datum;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.solarnetwork.domain.SerializeIgnore;
import net.solarnetwork.domain.datum.DatumSamplesOperations;
import net.solarnetwork.util.CollectionUtils;

public abstract class DatumSupport
implements Serializable {
    private static final long serialVersionUID = -4264640101068495508L;
    private Set<String> tags;

    public DatumSupport() {
    }

    public DatumSupport(DatumSamplesOperations other) {
        if (other != null) {
            this.tags = other.getTags() != null ? new LinkedHashSet<String>(other.getTags()) : null;
        }
    }

    public void clear() {
        this.tags = null;
    }

    protected String getMapString(String key, Map<String, ?> map) {
        return CollectionUtils.getMapString(key, map);
    }

    protected Integer getMapInteger(String key, Map<String, ?> map) {
        return CollectionUtils.getMapInteger(key, map);
    }

    protected Long getMapLong(String key, Map<String, ?> map) {
        return CollectionUtils.getMapLong(key, map);
    }

    protected Float getMapFloat(String key, Map<String, ?> map) {
        return CollectionUtils.getMapFloat(key, map);
    }

    protected Double getMapDouble(String key, Map<String, ?> map) {
        return CollectionUtils.getMapDouble(key, map);
    }

    protected BigDecimal getMapBigDecimal(String key, Map<String, ?> map) {
        return CollectionUtils.getMapBigDecimal(key, map);
    }

    @JsonIgnore
    @SerializeIgnore
    public Set<String> getTags() {
        return this.tags;
    }

    public void setTags(Set<String> tags) {
        this.tags = tags;
    }

    public Set<String> getT() {
        return this.getTags();
    }

    public void setT(Set<String> set) {
        this.setTags(set);
    }

    public boolean hasTag(String tag) {
        return this.tags != null && this.tags.contains(tag);
    }

    public boolean addTag(String tag) {
        if (tag == null) {
            return false;
        }
        Set<String> set = this.tags;
        if (set == null) {
            this.tags = set = new LinkedHashSet<String>(2);
        }
        return set.add(tag);
    }

    public boolean removeTag(String tag) {
        if (tag == null) {
            return false;
        }
        Set<String> set = this.tags;
        return set != null ? set.remove(tag) : false;
    }
}

