/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.domain.datum;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.solarnetwork.domain.BasicIdentity;
import net.solarnetwork.domain.Identity;
import net.solarnetwork.domain.datum.Datum;
import net.solarnetwork.domain.datum.DatumId;
import net.solarnetwork.domain.datum.DatumSamples;
import net.solarnetwork.domain.datum.DatumSamplesContainer;
import net.solarnetwork.domain.datum.DatumSamplesOperations;
import net.solarnetwork.domain.datum.DatumSamplesType;
import net.solarnetwork.domain.datum.MutableDatum;
import net.solarnetwork.domain.datum.MutableDatumSamplesOperations;
import net.solarnetwork.domain.datum.ObjectDatumKind;

public class GeneralDatum
extends BasicIdentity<DatumId>
implements Datum,
DatumSamplesContainer,
MutableDatum,
MutableDatumSamplesOperations,
Identity<DatumId>,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1934830001340995747L;
    private final DatumSamples samples;

    public GeneralDatum(DatumId id, DatumSamples samples) {
        super(id);
        this.samples = samples != null ? samples : new DatumSamples();
    }

    public GeneralDatum(String sourceId) {
        this(new DatumId(null, null, sourceId, Instant.now()), null);
    }

    public GeneralDatum(String sourceId, Instant timestamp) {
        this(new DatumId(null, null, sourceId, timestamp), null);
    }

    public GeneralDatum(String sourceId, Instant timestamp, DatumSamples samples) {
        this(new DatumId(null, null, sourceId, timestamp), samples);
    }

    public GeneralDatum(Long objectId, String sourceId, Instant timestamp, DatumSamples samples) {
        this(new DatumId(null, objectId, sourceId, timestamp), samples);
    }

    public static GeneralDatum nodeDatum(Long nodeId, String sourceId, Instant timestamp, DatumSamples samples) {
        return new GeneralDatum(DatumId.nodeId(nodeId, sourceId, timestamp), samples);
    }

    public static GeneralDatum locationDatum(Long locationId, String sourceId, Instant timestamp, DatumSamples samples) {
        return new GeneralDatum(DatumId.locationId(locationId, sourceId, timestamp), samples);
    }

    public String toString() {
        Instant ts;
        String sourceId;
        StringBuilder buf = new StringBuilder("Datum{kind=");
        buf.append((Object)this.getKind());
        Long objectId = this.getObjectId();
        if (objectId != null) {
            buf.append(",objectId=").append(objectId);
        }
        if ((sourceId = this.getSourceId()) != null) {
            buf.append(",sourceId=").append(sourceId);
        }
        if ((ts = this.getTimestamp()) != null) {
            buf.append(",ts=").append(ts);
        }
        if (!this.isEmpty()) {
            buf.append(",data=").append(this.samples);
        }
        buf.append("}");
        return buf.toString();
    }

    @Override
    public GeneralDatum clone() {
        return (GeneralDatum)super.clone();
    }

    @Override
    public GeneralDatum copyWithSamples(DatumSamplesOperations samples) {
        GeneralDatum copy = new GeneralDatum((DatumId)this.getId(), new DatumSamples());
        copy.samples.copyFrom(samples);
        return copy;
    }

    @Override
    public GeneralDatum copyWithId(DatumId id) {
        return new GeneralDatum(id, this.samples);
    }

    @Override
    public ObjectDatumKind getKind() {
        DatumId id = (DatumId)this.getId();
        return id != null ? id.getKind() : null;
    }

    @Override
    public Long getObjectId() {
        DatumId id = (DatumId)this.getId();
        return id != null ? id.getObjectId() : null;
    }

    @Override
    public String getSourceId() {
        DatumId id = (DatumId)this.getId();
        return id != null ? id.getSourceId() : null;
    }

    @Override
    public Instant getTimestamp() {
        DatumId id = (DatumId)this.getId();
        return id != null ? id.getTimestamp() : null;
    }

    @Override
    public Map<String, ?> getSampleData() {
        DatumSamples s = this.samples;
        return s != null ? s.getSampleData() : null;
    }

    @Override
    public Map<String, ?> asSimpleMap() {
        return this.createSimpleMap();
    }

    protected Map<String, Object> createSimpleMap() {
        Map<String, ?> sampleData;
        String[] datumTypes;
        String sourceId;
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        Instant timestamp = this.getTimestamp();
        if (timestamp != null) {
            map.put("created", timestamp.toEpochMilli());
        }
        if ((sourceId = this.getSourceId()) != null) {
            map.put("sourceId", sourceId);
        }
        if ((datumTypes = this.datumTypes()) != null && datumTypes.length > 0) {
            map.put("_DatumType", datumTypes[0]);
            map.put("_DatumTypes", datumTypes);
        }
        if ((sampleData = this.getSampleData()) != null) {
            map.putAll(sampleData);
        }
        return map;
    }

    protected String[] datumTypes() {
        return null;
    }

    @Override
    public DatumSamplesOperations asSampleOperations() {
        return this.samples;
    }

    @Override
    public MutableDatumSamplesOperations asMutableSampleOperations() {
        return this.samples;
    }

    @Override
    public boolean isEmpty() {
        return this.samples.isEmpty();
    }

    @Override
    public Map<String, ?> getSampleData(DatumSamplesType type) {
        return this.samples.getSampleData(type);
    }

    @Override
    public void setSampleData(DatumSamplesType type, Map<String, ?> data) {
        this.samples.setSampleData(type, data);
    }

    @Override
    public Integer getSampleInteger(DatumSamplesType type, String key) {
        return this.samples.getSampleInteger(type, key);
    }

    @Override
    public Long getSampleLong(DatumSamplesType type, String key) {
        return this.samples.getSampleLong(type, key);
    }

    @Override
    public Float getSampleFloat(DatumSamplesType type, String key) {
        return this.samples.getSampleFloat(type, key);
    }

    @Override
    public Double getSampleDouble(DatumSamplesType type, String key) {
        return this.samples.getSampleDouble(type, key);
    }

    @Override
    public BigDecimal getSampleBigDecimal(DatumSamplesType type, String key) {
        return this.samples.getSampleBigDecimal(type, key);
    }

    @Override
    public String getSampleString(DatumSamplesType type, String key) {
        return this.samples.getSampleString(type, key);
    }

    @Override
    public <V> V getSampleValue(DatumSamplesType type, String key) {
        return this.samples.getSampleValue(type, key);
    }

    @Override
    public Set<String> getTags() {
        return this.samples.getTags();
    }

    @Override
    public void clear() {
        this.samples.clear();
    }

    @Override
    public void setTags(Set<String> tags) {
        this.samples.setTags(tags);
    }

    @Override
    public <V> V findSampleValue(String key) {
        return this.samples.findSampleValue(key);
    }

    @Override
    public boolean hasTag(String tag) {
        return this.samples.hasTag(tag);
    }

    @Override
    public boolean addTag(String tag) {
        return this.samples.addTag(tag);
    }

    @Override
    public boolean hasSampleValue(String key) {
        return this.samples.hasSampleValue(key);
    }

    @Override
    public void putSampleValue(DatumSamplesType type, String key, Object value) {
        this.samples.putSampleValue(type, key, value);
    }

    public void removeTag(String tag) {
        this.samples.removeTag(tag);
    }

    @Override
    public boolean hasSampleValue(DatumSamplesType type, String key) {
        return this.samples.hasSampleValue(type, key);
    }

    @Override
    public DatumSamples getSamples() {
        return this.samples;
    }
}

