/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.domain.datum;

import java.math.BigDecimal;
import java.util.Map;
import java.util.Set;
import net.solarnetwork.domain.datum.DatumSamplesOperations;
import net.solarnetwork.domain.datum.DatumSamplesType;
import net.solarnetwork.domain.datum.MutableDatumSamplesOperations;
import net.solarnetwork.util.CollectionUtils;
import net.solarnetwork.util.ObjectUtils;

public class MapSampleOperations
implements MutableDatumSamplesOperations {
    private final Map<String, Object> parameters;
    private final DatumSamplesOperations datum;

    public MapSampleOperations(Map<String, Object> parameters) {
        this(parameters, null);
    }

    public MapSampleOperations(Map<String, Object> parameters, DatumSamplesOperations datum) {
        this.parameters = ObjectUtils.requireNonNullArgument(parameters, "parameters");
        this.datum = datum;
    }

    @Override
    public Map<String, ?> getSampleData(DatumSamplesType type) {
        return this.datum != null ? this.datum.getSampleData(type) : this.parameters;
    }

    @Override
    public Integer getSampleInteger(DatumSamplesType type, String key) {
        Integer result = null;
        if (this.datum != null) {
            result = this.datum.getSampleInteger(type, key);
        }
        return result != null ? result : CollectionUtils.getMapInteger(key, this.parameters);
    }

    @Override
    public Long getSampleLong(DatumSamplesType type, String key) {
        Long result = null;
        if (this.datum != null) {
            result = this.datum.getSampleLong(type, key);
        }
        return result != null ? result : CollectionUtils.getMapLong(key, this.parameters);
    }

    @Override
    public Float getSampleFloat(DatumSamplesType type, String key) {
        Float result = null;
        if (this.datum != null) {
            result = this.datum.getSampleFloat(type, key);
        }
        return result != null ? result : CollectionUtils.getMapFloat(key, this.parameters);
    }

    @Override
    public Double getSampleDouble(DatumSamplesType type, String key) {
        Double result = null;
        if (this.datum != null) {
            result = this.datum.getSampleDouble(type, key);
        }
        return result != null ? result : CollectionUtils.getMapDouble(key, this.parameters);
    }

    @Override
    public BigDecimal getSampleBigDecimal(DatumSamplesType type, String key) {
        BigDecimal result = null;
        if (this.datum != null) {
            result = this.datum.getSampleBigDecimal(type, key);
        }
        return result != null ? result : CollectionUtils.getMapBigDecimal(key, this.parameters);
    }

    @Override
    public String getSampleString(DatumSamplesType type, String key) {
        String result = null;
        if (this.datum != null) {
            result = this.datum.getSampleString(type, key);
        }
        return result != null ? result : CollectionUtils.getMapString(key, this.parameters);
    }

    @Override
    public <V> V getSampleValue(DatumSamplesType type, String key) {
        if (this.datum != null) {
            return this.datum.getSampleValue(type, key);
        }
        return this.findSampleValue(key);
    }

    @Override
    public boolean hasSampleValue(DatumSamplesType type, String key) {
        if (this.datum != null) {
            return this.datum.hasSampleValue(type, key);
        }
        return this.hasSampleValue(key);
    }

    @Override
    public <V> V findSampleValue(String key) {
        Object result = null;
        if (this.datum != null) {
            result = this.datum.findSampleValue(key);
        }
        return (V)(result != null ? result : this.parameters.get(key));
    }

    @Override
    public boolean hasSampleValue(String key) {
        return this.findSampleValue(key) != null;
    }

    @Override
    public void clear() {
        this.parameters.clear();
    }

    @Override
    public void putSampleValue(DatumSamplesType type, String key, Object value) {
        this.parameters.put(key, value);
    }

    @Override
    public void setSampleData(DatumSamplesType type, Map<String, ?> data) {
        if (data != null) {
            this.parameters.clear();
            this.parameters.putAll(data);
        }
    }

    @Override
    public Set<String> getTags() {
        return null;
    }

    @Override
    public void setTags(Set<String> tags) {
    }
}

