/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.domain.datum;

public enum ObjectDatumKind {
    Node('n'),
    Location('l');

    private final char key;

    private ObjectDatumKind(char key) {
        this.key = key;
    }

    public char getKey() {
        return this.key;
    }

    public static ObjectDatumKind forKey(String key) {
        if (key == null || key.isEmpty()) {
            throw new IllegalArgumentException("Key must not be null.");
        }
        if (key.length() == 1) {
            switch (key.charAt(0)) {
                case 'n': {
                    return Node;
                }
                case 'l': {
                    return Location;
                }
            }
            throw new IllegalArgumentException("Invalid ObjectDatumKind value [" + key + "]");
        }
        return ObjectDatumKind.valueOf(key);
    }
}

