/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.domain.datum;

import java.util.Collection;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.solarnetwork.domain.datum.DatumStreamMetadata;
import net.solarnetwork.domain.datum.ObjectDatumStreamMetadata;
import net.solarnetwork.util.ObjectUtils;

public interface ObjectDatumStreamMetadataProvider {
    public Collection<UUID> metadataStreamIds();

    public ObjectDatumStreamMetadata metadataForStreamId(UUID var1);

    public ObjectDatumStreamMetadata metadataForObjectSource(Long var1, String var2);

    public static ObjectDatumStreamMetadataProvider staticProvider(final Iterable<ObjectDatumStreamMetadata> metadatas) {
        ObjectUtils.requireNonNullArgument(metadatas, "metadatas");
        return new ObjectDatumStreamMetadataProvider(){

            @Override
            public Collection<UUID> metadataStreamIds() {
                return StreamSupport.stream(metadatas.spliterator(), false).map(DatumStreamMetadata::getStreamId).collect(Collectors.toList());
            }

            @Override
            public ObjectDatumStreamMetadata metadataForStreamId(UUID streamId) {
                if (streamId == null) {
                    return null;
                }
                for (ObjectDatumStreamMetadata meta : metadatas) {
                    if (meta == null || !streamId.equals(meta.getStreamId())) continue;
                    return meta;
                }
                return null;
            }

            @Override
            public ObjectDatumStreamMetadata metadataForObjectSource(Long objectId, String sourceId) {
                if (objectId == null || sourceId == null) {
                    return null;
                }
                for (ObjectDatumStreamMetadata meta : metadatas) {
                    if (meta == null || !objectId.equals(meta.getObjectId()) || !sourceId.equals(meta.getSourceId())) continue;
                    return meta;
                }
                return null;
            }
        };
    }
}

