/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.domain.tariff;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import net.solarnetwork.domain.tariff.Tariff;

public class CompositeTariff
implements Tariff {
    private final Collection<? extends Tariff> tariffs;

    public CompositeTariff(Collection<? extends Tariff> tariffs) {
        this.tariffs = tariffs != null ? tariffs : Collections.emptyList();
    }

    @Override
    public Map<String, Tariff.Rate> getRates() {
        if (this.tariffs.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Tariff.Rate> r = new LinkedHashMap<String, Tariff.Rate>();
        for (Tariff tariff : this.tariffs) {
            Map<String, Tariff.Rate> tr = tariff.getRates();
            if (tr == null) continue;
            for (Map.Entry<String, Tariff.Rate> me : tr.entrySet()) {
                if (r.containsKey(me.getKey())) continue;
                r.put(me.getKey(), me.getValue());
            }
        }
        return r;
    }
}

