/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.domain.tariff;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.time.DateTimeException;
import java.time.format.TextStyle;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import net.solarnetwork.domain.tariff.Tariff;
import net.solarnetwork.domain.tariff.TemporalRangesTariff;
import net.solarnetwork.util.DateUtils;
import net.solarnetwork.util.StringUtils;
import org.supercsv.io.CsvListWriter;
import org.supercsv.io.ICsvListWriter;
import org.supercsv.prefs.CsvPreference;

public class CsvTemporalRangeTariffParser {
    private final Locale locale;

    public CsvTemporalRangeTariffParser() {
        this(null);
    }

    public CsvTemporalRangeTariffParser(Locale locale) {
        this.locale = locale != null ? locale : Locale.getDefault();
    }

    /*
     * Exception decompiling
     */
    public List<TemporalRangesTariff> parseTariffs(Reader reader) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 10[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void formatCsv(List<TemporalRangesTariff> tariffs, Writer writer) throws IOException {
        if (tariffs == null || tariffs.isEmpty()) {
            return;
        }
        List<String> rateNames = this.extractRateDescriptions(tariffs);
        String[] headers = new String[4 + rateNames.size()];
        headers[0] = "Month";
        headers[1] = "Day";
        headers[2] = "Weekday";
        headers[3] = "Time";
        int len = rateNames.size();
        for (int i = 0; i < len; ++i) {
            headers[i + 4] = rateNames.get(i);
        }
        try (CsvListWriter csvWriter = new CsvListWriter(writer, CsvPreference.STANDARD_PREFERENCE);){
            csvWriter.writeHeader(headers);
            try {
                for (int i = 4; i < headers.length; ++i) {
                    headers[i] = StringUtils.simpleIdValue(headers[i]);
                }
                for (TemporalRangesTariff tariff : tariffs) {
                    this.encodeToCsv(tariff, headers, (ICsvListWriter)csvWriter);
                }
            }
            catch (DateTimeException e) {
                throw new IllegalArgumentException(String.format("Error formatting date range value in CSV row %d: %s", csvWriter.getLineNumber(), e.getMessage()), e);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format("Error formatting CSV row %d: %s", csvWriter.getLineNumber(), e.getMessage()), e);
            }
        }
    }

    private void encodeToCsv(TemporalRangesTariff tariff, String[] headers, ICsvListWriter csvWriter) throws IOException {
        String[] row = new String[headers.length];
        row[0] = DateUtils.formatRange(ChronoField.MONTH_OF_YEAR, tariff.getMonthRange(), this.locale, TextStyle.SHORT);
        row[1] = DateUtils.formatRange(ChronoField.DAY_OF_MONTH, tariff.getDayOfMonthRange(), this.locale, TextStyle.SHORT);
        row[2] = DateUtils.formatRange(ChronoField.DAY_OF_WEEK, tariff.getDayOfWeekRange(), this.locale, TextStyle.SHORT);
        row[3] = DateUtils.formatRange(ChronoField.MINUTE_OF_DAY, tariff.getMinuteOfDayRange(), this.locale, TextStyle.SHORT);
        for (int i = 4; i < headers.length; ++i) {
            Tariff.Rate r = tariff.getRates().get(headers[i]);
            row[i] = r != null ? r.getAmount().toPlainString() : null;
        }
        csvWriter.write(row);
    }

    private List<String> extractRateDescriptions(List<TemporalRangesTariff> tariffs) {
        return new ArrayList<String>(tariffs.stream().flatMap(t -> t.getRates().values().stream()).map(Tariff.Rate::getDescription).collect(Collectors.toCollection(LinkedHashSet::new)));
    }
}

