/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.event;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.Instant;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import net.solarnetwork.event.AppEvent;

@JsonDeserialize(builder=Builder.class)
public class BasicAppEvent
implements AppEvent {
    private final String topic;
    private final Instant created;
    private final Map<String, ?> eventProperties;

    public BasicAppEvent(String topic, Map<String, ?> eventProperties) {
        this(topic, Instant.now(), eventProperties);
    }

    public BasicAppEvent(String topic, Instant created, Map<String, ?> eventProperties) {
        if (topic == null || topic.isEmpty()) {
            throw new IllegalArgumentException("The topic parameter must not be null.");
        }
        this.topic = topic;
        if (created == null) {
            created = Instant.now();
        }
        this.created = created;
        if (eventProperties == null) {
            eventProperties = Collections.emptyMap();
        }
        this.eventProperties = eventProperties;
    }

    private BasicAppEvent(Builder builder) {
        this(builder.topic, builder.created, builder.eventProperties);
    }

    public int hashCode() {
        return Objects.hash(this.created, this.eventProperties, this.topic);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BasicAppEvent)) {
            return false;
        }
        BasicAppEvent other = (BasicAppEvent)obj;
        return Objects.equals(this.created, other.created) && Objects.equals(this.eventProperties, other.eventProperties) && Objects.equals(this.topic, other.topic);
    }

    public String toString() {
        StringBuilder builder2 = new StringBuilder();
        builder2.append("BasicAppEvent{");
        builder2.append("topic=");
        builder2.append(this.topic);
        builder2.append(", ");
        builder2.append("created=");
        builder2.append(this.created);
        builder2.append(", ");
        if (this.eventProperties != null && !this.eventProperties.isEmpty()) {
            builder2.append("eventProperties=");
            builder2.append(this.eventProperties);
        }
        builder2.append("}");
        return builder2.toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public String getTopic() {
        return this.topic;
    }

    @Override
    public Instant getCreated() {
        return this.created;
    }

    @Override
    public Map<String, ?> getEventProperties() {
        return this.eventProperties;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static class Builder {
        private String topic;
        private Instant created;
        private Map<String, ?> eventProperties = Collections.emptyMap();

        protected Builder() {
        }

        protected Builder(AppEvent basicAppEvent) {
            this.topic = basicAppEvent.getTopic();
            this.created = basicAppEvent.getCreated();
            this.eventProperties = basicAppEvent.getEventProperties();
        }

        public String getTopic() {
            return this.topic;
        }

        public Builder withTopic(String topic) {
            this.topic = topic;
            return this;
        }

        public Instant getCreated() {
            return this.created;
        }

        public Builder withCreated(Instant created) {
            this.created = created;
            return this;
        }

        public Map<String, ?> getEventProperties() {
            return this.eventProperties;
        }

        public Builder withEventProperties(Map<String, ?> eventProperties) {
            if (eventProperties == null) {
                eventProperties = Collections.emptyMap();
            }
            this.eventProperties = eventProperties;
            return this;
        }

        public BasicAppEvent build() {
            return new BasicAppEvent(this);
        }
    }
}

