/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.event;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import net.solarnetwork.event.AppEvent;
import net.solarnetwork.event.AppEventHandler;
import net.solarnetwork.event.AppEventHandlerRegistrar;
import net.solarnetwork.event.AppEventPublisher;
import net.solarnetwork.util.ObjectUtils;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;

public class SimpleAppEventManager
implements AppEventHandlerRegistrar,
AppEventPublisher {
    private final PathMatcher pathMatcher;
    private final ConcurrentMap<String, Set<AppEventHandler>> eventHandlers;
    private final Executor executor;

    public SimpleAppEventManager() {
        this((PathMatcher)new AntPathMatcher(), Executors.newWorkStealingPool());
    }

    public SimpleAppEventManager(Executor executor) {
        this((PathMatcher)new AntPathMatcher(), executor);
    }

    public SimpleAppEventManager(PathMatcher pathMatcher, Executor executor) {
        this(pathMatcher, executor, new ConcurrentHashMap<String, Set<AppEventHandler>>(32, 0.9f, 4));
    }

    public SimpleAppEventManager(PathMatcher pathMatcher, Executor executor, ConcurrentMap<String, Set<AppEventHandler>> handlerMap) {
        this.pathMatcher = ObjectUtils.requireNonNullArgument(pathMatcher, "pathMatcher");
        this.executor = ObjectUtils.requireNonNullArgument(executor, "executor");
        this.eventHandlers = ObjectUtils.requireNonNullArgument(handlerMap, "handlerMap");
    }

    @Override
    public void registerEventHandler(AppEventHandler handler, String ... topics) {
        if (handler == null) {
            return;
        }
        for (String topic : topics) {
            this.eventHandlers.computeIfAbsent(topic, k -> new CopyOnWriteArraySet()).add(handler);
        }
    }

    @Override
    public void deregisterEventHandler(AppEventHandler handler) {
        for (Set handlers : this.eventHandlers.values()) {
            handlers.remove(handler);
        }
    }

    @Override
    public void postEvent(final AppEvent event) {
        for (Map.Entry me : this.eventHandlers.entrySet()) {
            String topic = event.getTopic();
            if (!this.pathMatcher.match((String)me.getKey(), topic)) continue;
            for (final AppEventHandler handler : (Set)me.getValue()) {
                this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        handler.handleEvent(event);
                    }
                });
            }
        }
    }
}

