/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.io;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.compress.utils.CountingInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.Resource;

public class DecompressingResource
extends AbstractResource {
    private static final Logger log = LoggerFactory.getLogger(DecompressingResource.class);
    public static final String NO_KNOWN_COMPRESSION_TYPE = "";
    private final Resource source;
    private String compressionType;
    private long contentLength = -1L;

    public DecompressingResource(Resource source) {
        this(source, null);
    }

    public DecompressingResource(Resource source, String compressionType) {
        this(source, compressionType, -1L);
    }

    public DecompressingResource(Resource source, String compressionType, long contentLength) {
        this.source = source;
        this.compressionType = compressionType;
        this.contentLength = contentLength;
    }

    public String getDescription() {
        StringBuilder builder = new StringBuilder();
        builder.append("DecompressingResource{");
        if (this.compressionType != null) {
            builder.append("compressionType=");
            builder.append(this.compressionType);
            builder.append(", ");
        }
        builder.append("contentLength=");
        builder.append(this.contentLength);
        builder.append(", ");
        if (this.source != null) {
            builder.append("source=");
            builder.append(this.source);
        }
        builder.append("}");
        return builder.toString();
    }

    public InputStream getInputStream() throws IOException {
        BufferedInputStream in = new BufferedInputStream(this.source.getInputStream());
        if (this.compressionType == null) {
            try {
                this.compressionType = CompressorStreamFactory.detect((InputStream)in);
            }
            catch (CompressorException e) {
                log.debug("No known compression type detected in {}, will return raw stream", (Object)this.source);
                this.compressionType = NO_KNOWN_COMPRESSION_TYPE;
            }
        }
        if (NO_KNOWN_COMPRESSION_TYPE.equals(this.compressionType)) {
            return in;
        }
        try {
            return new CompressorStreamFactory().createCompressorInputStream(this.compressionType, (InputStream)in);
        }
        catch (CompressorException e) {
            throw new IOException("Error handling compression of resource " + this.source + ": " + e.getMessage());
        }
    }

    public String getCompressionType() {
        if (this.compressionType == null) {
            try {
                InputStream in = this.getInputStream();
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.compressionType;
    }

    public URL getURL() throws IOException {
        return this.source.getURL();
    }

    public File getFile() throws IOException {
        return this.source.getFile();
    }

    public String getFilename() {
        return this.source.getFilename();
    }

    public boolean exists() {
        return this.source.exists();
    }

    public boolean isReadable() {
        return this.source.isReadable();
    }

    public boolean isOpen() {
        return this.source.isOpen();
    }

    public URI getURI() throws IOException {
        return this.source.getURI();
    }

    public long contentLength() throws IOException {
        if (this.contentLength < 0L) {
            try (CountingInputStream in = new CountingInputStream(this.getInputStream());){
                byte[] tmp = new byte[4096];
                while (in.read(tmp) != -1) {
                }
                this.contentLength = in.getBytesRead();
            }
        }
        return this.contentLength;
    }

    public long lastModified() throws IOException {
        return this.source.lastModified();
    }

    public Resource createRelative(String relativePath) throws IOException {
        return this.source.createRelative(relativePath);
    }
}

