/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.io;

import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.springframework.util.MimeType;

public interface ResourceMetadata {
    public static final MimeType DEFAULT_CONTENT_TYPE = MimeType.valueOf((String)"application/octet-stream");
    public static final String CONTENT_TYPE_KEY = "Content-Type";
    public static final String MODIFIED_KEY = "Last-Modified";

    public Date getModified();

    default public MimeType getContentType() {
        return DEFAULT_CONTENT_TYPE;
    }

    default public Map<String, ?> asMap() {
        TreeMap<String, Object> map = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        this.populateMap(map);
        return map;
    }

    default public void populateMap(Map<String, Object> map) {
        Date d = this.getModified();
        if (d != null) {
            map.put(MODIFIED_KEY, d);
        }
        map.put(CONTENT_TYPE_KEY, this.getContentType());
    }

    default public Map<String, ?> asStandardMap() {
        TreeMap<String, Object> map = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        this.populateMap(map);
        Iterator itr = map.keySet().iterator();
        while (itr.hasNext()) {
            String k = (String)itr.next();
            if (!this.isCustomKey(k)) continue;
            itr.remove();
        }
        return map;
    }

    default public Map<String, ?> asCustomMap() {
        TreeMap<String, Object> map = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        this.populateMap(map);
        Iterator itr = map.keySet().iterator();
        while (itr.hasNext()) {
            String k = (String)itr.next();
            if (this.isCustomKey(k)) continue;
            itr.remove();
        }
        return map;
    }

    default public boolean isCustomKey(String key) {
        switch (key) {
            case "Content-Type": 
            case "Last-Modified": {
                return false;
            }
        }
        return true;
    }
}

