/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.io;

import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import net.solarnetwork.io.ResourceMetadata;
import org.springframework.util.MimeType;

public class SimpleResourceMetadata
implements ResourceMetadata {
    private final Date modified;
    private final MimeType contentType;
    private Map<String, Object> extendedMetadata;

    public SimpleResourceMetadata(Date modified) {
        this(modified, DEFAULT_CONTENT_TYPE);
    }

    public SimpleResourceMetadata(Date modified, MimeType contentType) {
        this(modified, contentType, null);
    }

    public SimpleResourceMetadata(Date modified, MimeType contentType, Map<String, ?> extendedMetadata) {
        this.modified = modified;
        this.contentType = contentType != null ? contentType : DEFAULT_CONTENT_TYPE;
        this.putExtendedMetadata(extendedMetadata);
    }

    @Override
    public final Date getModified() {
        return this.modified;
    }

    @Override
    public final MimeType getContentType() {
        return this.contentType;
    }

    @Override
    public void populateMap(Map<String, Object> map) {
        Map<String, Object> extended = this.getExtendedMetadata();
        if (extended != null) {
            map.putAll(extended);
        }
        ResourceMetadata.super.populateMap(map);
    }

    public final Map<String, Object> getExtendedMetadata() {
        return this.extendedMetadata;
    }

    public final void putExtendedMetadata(Map<String, ?> extendedMetadata) {
        if (extendedMetadata == null || extendedMetadata.isEmpty()) {
            return;
        }
        Map<String, Object> map = this.getExtendedMetadata();
        if (map == null) {
            map = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
            this.extendedMetadata = map;
        }
        map.putAll(extendedMetadata);
    }
}

