/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.zip.GZIPInputStream;

public final class StreamUtils {
    public static final int GZIP_MAGIC = 8075;

    public static InputStream inputStreamForPossibleGzipStream(InputStream in) throws IOException {
        int count;
        int readCount;
        if (in instanceof GZIPInputStream) {
            return in;
        }
        PushbackInputStream s = new PushbackInputStream(in, 2);
        byte[] magic = new byte[]{-1, -1};
        for (count = 0; count < 2 && (readCount = s.read(magic, count, 2 - count)) >= 0; count += readCount) {
        }
        s.unread(magic, 0, count);
        if (magic[0] == 31 && magic[1] == -117) {
            return new GZIPInputStream(s);
        }
        return s;
    }
}

