/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Map;
import java.util.zip.DeflaterInputStream;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import net.solarnetwork.io.ResultStatusException;
import net.solarnetwork.io.UnicodeReader;
import net.solarnetwork.service.SSLService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.FileCopyUtils;

public final class UrlUtils {
    public static final String UTF8_CHARSET = "UTF-8";
    public static final String ACCEPT_ANYTHING = "*/*";
    public static final String ACCEPT_TEXT = "text/*";
    public static final String ACCEPT_JSON = "application/json,text/json";
    public static final String ACCEPT_TEXT_AND_JSON = "text/*,application/json";
    public static final String ACCEPT_XML = "application/xml,text/xml";
    public static final String ACCEPT_TEXT_AND_XML = "text/*,application/xml";
    public static final String ACCEPT_TEXT_AND_JSON_AND_XML = "text/*,application/json,application/xml";
    public static final String HTTP_METHOD_GET = "GET";
    public static final String HTTP_METHOD_PATCH = "PATCH";
    public static final String HTTP_METHOD_POST = "POST";
    public static final String HTTP_METHOD_PUT = "PUT";
    private static final Logger log = LoggerFactory.getLogger(UrlUtils.class);

    public static InputStream getInputStreamFromURLConnection(URLConnection conn) throws IOException {
        String enc = conn.getContentEncoding();
        String type = conn.getContentType();
        if (conn instanceof HttpURLConnection) {
            HttpURLConnection httpConn = (HttpURLConnection)conn;
            log.trace("HTTP {} {} response code: {}", new Object[]{httpConn.getRequestMethod(), httpConn.getURL(), httpConn.getResponseCode()});
            if (httpConn.getResponseCode() < 200 || httpConn.getResponseCode() > 299) {
                log.info("Non-200 HTTP response from {} {}: {}", new Object[]{conn.getURL(), httpConn.getRequestMethod(), httpConn.getResponseCode()});
            }
        }
        log.trace("RESP content type [{}] encoded as [{}]", (Object)type, (Object)enc);
        InputStream is = conn.getInputStream();
        if ("gzip".equalsIgnoreCase(enc)) {
            is = new GZIPInputStream(is);
        } else if ("deflate".equalsIgnoreCase(enc)) {
            is = new DeflaterInputStream(is);
        }
        return is;
    }

    public static Reader getUnicodeReaderFromURLConnection(URLConnection conn) throws IOException {
        return new BufferedReader(new UnicodeReader(UrlUtils.getInputStreamFromURLConnection(conn), null));
    }

    public static URLConnection getURLConnection(String url, String httpMethod, int timeout, SSLService sslService) throws IOException {
        return UrlUtils.getURLConnection(url, httpMethod, ACCEPT_TEXT, timeout, sslService);
    }

    public static URLConnection getURLConnection(String url, String httpMethod, String accept, int timeout, SSLService sslService) throws IOException {
        SSLSocketFactory factory;
        URL connUrl;
        try {
            connUrl = new URI(url).toURL();
        }
        catch (URISyntaxException e) {
            throw new IOException("Invalid URL [" + url + "]", e);
        }
        URLConnection conn = connUrl.openConnection();
        if (httpMethod != null && conn instanceof HttpURLConnection) {
            HttpURLConnection hConn = (HttpURLConnection)conn;
            hConn.setRequestMethod(httpMethod);
        }
        if (sslService != null && conn instanceof HttpsURLConnection && (factory = sslService.getSSLSocketFactory()) != null) {
            HttpsURLConnection hConn = (HttpsURLConnection)conn;
            hConn.setSSLSocketFactory(factory);
        }
        if (accept != null) {
            conn.setRequestProperty("Accept", accept);
        }
        conn.setRequestProperty("Accept-Encoding", "gzip,deflate");
        conn.setDoInput(true);
        conn.setDoOutput(HTTP_METHOD_PATCH.equalsIgnoreCase(httpMethod) || HTTP_METHOD_POST.equalsIgnoreCase(httpMethod) || HTTP_METHOD_PUT.equalsIgnoreCase(httpMethod));
        if (timeout > 0) {
            conn.setConnectTimeout(timeout);
            conn.setReadTimeout(timeout);
        }
        return conn;
    }

    public static <T extends Appendable & CharSequence> void appendURLEncodedValue(T buf, String key, Object value) {
        if (value == null) {
            return;
        }
        try {
            if (((CharSequence)buf).length() > 0) {
                buf.append('&');
            }
            buf.append(URLEncoder.encode(key, UTF8_CHARSET)).append('=').append(URLEncoder.encode(value.toString(), UTF8_CHARSET));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String urlEncoded(Map<String, ?> data) {
        if (data == null || data.size() < 0) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        for (Map.Entry<String, ?> me : data.entrySet()) {
            Object val = me.getValue();
            if (val instanceof Collection) {
                for (Object colVal : (Collection)val) {
                    UrlUtils.appendURLEncodedValue(buf, me.getKey(), colVal);
                }
                continue;
            }
            if (val.getClass().isArray()) {
                for (Object arrayVal : (Object[])val) {
                    UrlUtils.appendURLEncodedValue(buf, me.getKey(), arrayVal);
                }
                continue;
            }
            UrlUtils.appendURLEncodedValue(buf, me.getKey(), val);
        }
        return buf.toString();
    }

    public static URLConnection postXWWWFormURLEncodedData(String url, String accept, Map<String, ?> data, int timeout, SSLService sslService) throws IOException {
        HttpURLConnection http;
        int status;
        URLConnection conn = UrlUtils.getURLConnection(url, HTTP_METHOD_POST, accept, timeout, sslService);
        conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        String body = UrlUtils.urlEncoded(data);
        log.trace("HTTP POST {} for {} with application/x-www-form-urlencoded data: {}", new Object[]{url, accept, body});
        OutputStreamWriter out = new OutputStreamWriter(conn.getOutputStream(), UTF8_CHARSET);
        FileCopyUtils.copy((Reader)new StringReader(body), (Writer)out);
        if (conn instanceof HttpURLConnection && ((status = (http = (HttpURLConnection)conn).getResponseCode()) < 200 || status > 299)) {
            throw new ResultStatusException(http.getURL(), http.getResponseCode(), "HTTP result status not in the 200-299 range: " + http.getResponseCode() + " " + http.getResponseMessage());
        }
        return conn;
    }

    public static String postXWWWFormURLEncodedDataForString(String url, String accept, Map<String, ?> data, int timeout, SSLService sslService) throws IOException {
        URLConnection conn = UrlUtils.postXWWWFormURLEncodedData(url, accept, data, timeout, sslService);
        return FileCopyUtils.copyToString((Reader)UrlUtils.getUnicodeReaderFromURLConnection(conn));
    }

    public static URLConnection getURL(String url, String accept, Map<String, ?> queryParameters, int timeout, SSLService sslService) throws IOException {
        HttpURLConnection http;
        int status;
        String query = UrlUtils.urlEncoded(queryParameters);
        String fullUrl = url;
        if (query != null) {
            fullUrl = fullUrl + query;
        }
        URLConnection conn = UrlUtils.getURLConnection(fullUrl, HTTP_METHOD_GET, accept, timeout, sslService);
        log.trace("HTTP GET {} for {}", (Object)fullUrl, (Object)accept);
        if (conn instanceof HttpURLConnection && ((status = (http = (HttpURLConnection)conn).getResponseCode()) < 200 || status > 299)) {
            throw new ResultStatusException(http.getURL(), http.getResponseCode(), "HTTP result status not in the 200-299 range: " + http.getResponseCode() + " " + http.getResponseMessage());
        }
        return conn;
    }

    public static String getURLForString(String url, String accept, Map<String, ?> queryParameters, int timeout, SSLService sslService) throws IOException {
        URLConnection conn = UrlUtils.getURL(url, accept, queryParameters, timeout, sslService);
        return FileCopyUtils.copyToString((Reader)UrlUtils.getUnicodeReaderFromURLConnection(conn));
    }
}

