/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.security;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.List;
import java.util.TreeSet;
import net.solarnetwork.security.AuthorizationUtils;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public abstract class AbstractAuthorizationBuilder<T extends AbstractAuthorizationBuilder<T>> {
    public static final String AUTHORIZATION_COMPONENT_CREDENTIAL = "Credential";
    public static final String AUTHORIZATION_COMPONENT_HEADERS = "SignedHeaders";
    public static final String AUTHORIZATION_COMPONENT_SIGNATURE = "Signature";
    private final String identifier;
    private MultiValueMap<String, String> headers;
    private String verb;
    private String requestPath;
    private Instant date;
    private byte[] signingKey;
    private byte[] contentSha256;

    public AbstractAuthorizationBuilder(String identifier) {
        this.identifier = identifier;
        this.reset();
    }

    public T reset() {
        this.contentSha256 = null;
        this.headers = null;
        return ((AbstractAuthorizationBuilder)((AbstractAuthorizationBuilder)this.verb("GET")).path("/")).date(null);
    }

    public T date(Instant date) {
        Instant d;
        this.date = d = (date == null ? Instant.now() : date).truncatedTo(ChronoUnit.SECONDS);
        return (T)this;
    }

    public Instant getDate() {
        return this.date;
    }

    public T verb(String verb) {
        if (verb == null) {
            throw new IllegalArgumentException("The verb argument must not be null.");
        }
        this.verb = verb;
        return (T)this;
    }

    public String getVerb() {
        return this.verb;
    }

    public T path(String path) {
        if (this.verb == null) {
            throw new IllegalArgumentException("The path argument must not be null.");
        }
        this.requestPath = path;
        return (T)this;
    }

    public String getPath() {
        return this.requestPath;
    }

    public T host(String host) {
        return this.header("host", host);
    }

    public T contentSha256(byte[] digest) {
        byte[] copy = null;
        if (digest != null && digest.length >= 32) {
            copy = new byte[32];
            System.arraycopy(digest, 0, copy, 0, 32);
        }
        this.contentSha256 = copy;
        return (T)this;
    }

    public byte[] getContentSha256() {
        return this.contentSha256;
    }

    protected void appendContentSha256(StringBuilder buf) {
        byte[] digest = this.contentSha256;
        buf.append(digest == null || digest.length < 1 ? AuthorizationUtils.EMPTY_STRING_SHA256_HEX : Hex.encodeHexString((byte[])digest));
    }

    protected void appendHeaders(String[] headerNames, StringBuilder buf) {
        MultiValueMap<String, String> m = this.getHeaders();
        for (String h : headerNames) {
            List vals;
            List list = vals = m != null ? (List)m.get((Object)h) : null;
            if (vals == null || vals.isEmpty()) {
                buf.append('\n');
                continue;
            }
            for (String v : vals) {
                buf.append(h).append(':');
                if (v != null && !v.isEmpty()) {
                    buf.append(v.trim().replaceAll(" {2,}", " "));
                }
                buf.append('\n');
            }
        }
    }

    public T headers(MultiValueMap<String, String> headers) {
        this.headers = headers;
        return (T)this;
    }

    public MultiValueMap<String, String> getHeaders() {
        return this.headers;
    }

    public T header(String headerName, String ... headerValue) {
        if (headerName == null || headerName.isEmpty() || headerValue == null || headerValue.length < 1) {
            throw new IllegalArgumentException("The headerName and headerValue arguments must not be null or empty.");
        }
        if (this.headers == null) {
            this.headers = new LinkedMultiValueMap(4);
        }
        this.headers.put((Object)headerName.toLowerCase(), Arrays.asList(headerValue));
        return (T)this;
    }

    public String headerValue(String headerName) {
        List<String> values = this.headerValues(headerName);
        return values != null && !values.isEmpty() ? values.get(0) : null;
    }

    public List<String> headerValues(String headerName) {
        return headerName != null && this.headers != null ? (List)this.headers.get((Object)headerName.toLowerCase()) : null;
    }

    public T saveSigningKey(String secret) {
        this.signingKey = this.computeSigningKey(this.date, secret);
        return (T)this;
    }

    public T signingKey(byte[] key) {
        this.signingKey = key;
        return (T)this;
    }

    public String signingKeyHex() {
        byte[] k = this.signingKey;
        return k != null ? Hex.encodeHexString((byte[])k) : null;
    }

    protected abstract String signingKeyMessageLiteral();

    public byte[] computeSigningKey(Instant date, String secret) {
        if (secret == null || date == null) {
            throw new IllegalArgumentException("The secret and date arguments must not be null.");
        }
        String day = AuthorizationUtils.AUTHORIZATION_DATE_FORMATTER.format(date);
        return AuthorizationUtils.computeHmacSha256(AuthorizationUtils.computeHmacSha256(this.schemeName() + secret, day), this.signingKeyMessageLiteral());
    }

    public String[] sortedHeaderNames() {
        TreeSet<String> headerNames = new TreeSet<String>();
        MultiValueMap<String, String> h = this.headers;
        int count = 0;
        if (h != null) {
            for (String k : h.keySet()) {
                if (k == null) continue;
                headerNames.add(k.toLowerCase());
                ++count;
            }
        }
        return headerNames.toArray(new String[count]);
    }

    public String computeCanonicalRequestMessage() {
        return this.computeCanonicalRequestMessage(this.sortedHeaderNames());
    }

    protected abstract String computeCanonicalRequestMessage(String[] var1);

    public String computeSignatureData(Instant date, String canonicalRequestMessage) {
        return this.schemeName() + "-HMAC-SHA256\n" + AuthorizationUtils.AUTHORIZATION_TIMESTAMP_FORMATTER.format(date) + "\n" + Hex.encodeHexString((byte[])DigestUtils.sha256((String)canonicalRequestMessage));
    }

    public String build() {
        return this.build(this.signingKey);
    }

    public String build(String secret) {
        byte[] signingKey = this.computeSigningKey(this.date, secret);
        return this.build(signingKey);
    }

    protected abstract String schemeName();

    private String build(byte[] signingKey) {
        String[] sortedHeaderNames = this.sortedHeaderNames();
        String signature = this.buildSignature(signingKey, sortedHeaderNames);
        StringBuilder buf = new StringBuilder(this.schemeName());
        buf.append(' ').append(AUTHORIZATION_COMPONENT_CREDENTIAL).append("=").append(this.identifier);
        buf.append(",").append(AUTHORIZATION_COMPONENT_HEADERS).append("=").append(AuthorizationUtils.semiColonDelimitedList(sortedHeaderNames));
        buf.append(",").append(AUTHORIZATION_COMPONENT_SIGNATURE).append("=").append(signature);
        return buf.toString();
    }

    public String buildSignature() {
        return this.buildSignature(this.signingKey, this.sortedHeaderNames());
    }

    public String buildSignature(String secret) {
        byte[] signingKey = this.computeSigningKey(this.date, secret);
        return this.buildSignature(signingKey, this.sortedHeaderNames());
    }

    private String buildSignature(byte[] signingKey, String[] sortedHeaderNames) {
        String signatureData = this.computeSignatureData(this.date, this.computeCanonicalRequestMessage(sortedHeaderNames));
        return AuthorizationUtils.computeHmacSha256Hex(signingKey, signatureData);
    }
}

