/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.security;

import java.util.Arrays;
import net.solarnetwork.security.SecurityException;

public class AuthorizationException
extends SecurityException {
    private static final long serialVersionUID = -7269908721527606492L;
    private final Reason reason;
    private final String email;
    private final Object id;

    public AuthorizationException(String username, Reason reason) {
        this.reason = reason;
        this.email = username;
        this.id = null;
    }

    public AuthorizationException(Reason reason, Object id) {
        this.reason = reason;
        this.email = null;
        this.id = id;
    }

    public String getEmail() {
        return this.email;
    }

    public Object getId() {
        return this.id;
    }

    public Reason getReason() {
        return this.reason;
    }

    @Override
    public String getMessage() {
        return this.reason == null ? null : this.reason.toString() + " [" + (this.email == null ? (this.id != null && this.id.getClass().isArray() ? Arrays.toString((Object[])this.id) : this.id) : this.email) + "]";
    }

    public static enum Reason {
        BAD_PASSWORD,
        UNKNOWN_EMAIL,
        DUPLICATE_EMAIL,
        REGISTRATION_NOT_CONFIRMED,
        REGISTRATION_ALREADY_CONFIRMED,
        FORGOTTEN_PASSWORD_NOT_CONFIRMED,
        ACCESS_DENIED,
        ANONYMOUS_ACCESS_DENIED,
        UNKNOWN_OBJECT;

    }
}

