/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.security;

import java.time.Instant;
import net.solarnetwork.security.AbstractAuthorizationBuilder;
import net.solarnetwork.security.AuthorizationUtils;

public class SnsAuthorizationBuilder
extends AbstractAuthorizationBuilder<SnsAuthorizationBuilder> {
    public static final String SCHEME_NAME = "SNS";
    public static final String SIGNING_KEY_MESSAGE = "sns_request";

    public SnsAuthorizationBuilder(String identifier) {
        super(identifier);
    }

    @Override
    public SnsAuthorizationBuilder reset() {
        return (SnsAuthorizationBuilder)super.reset();
    }

    @Override
    public SnsAuthorizationBuilder date(Instant date) {
        super.date(date);
        return (SnsAuthorizationBuilder)this.header("date", AuthorizationUtils.AUTHORIZATION_DATE_HEADER_FORMATTER.format(this.getDate()));
    }

    @Override
    protected String signingKeyMessageLiteral() {
        return SIGNING_KEY_MESSAGE;
    }

    @Override
    protected String schemeName() {
        return SCHEME_NAME;
    }

    @Override
    protected String computeCanonicalRequestMessage(String[] headerNames) {
        StringBuilder buf = new StringBuilder(this.getVerb()).append('\n');
        buf.append(this.getPath()).append('\n');
        if (headerNames == null || headerNames.length < 1) {
            buf.append('\n').append('\n');
        } else {
            this.appendHeaders(headerNames, buf);
            buf.append(AuthorizationUtils.semiColonDelimitedList(headerNames)).append('\n');
        }
        this.appendContentSha256(buf);
        return buf.toString();
    }
}

