/*
 * Decompiled with CFR 0.152.
 */
package net.solarnetwork.security;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.solarnetwork.security.AbstractAuthorizationBuilder;
import net.solarnetwork.security.AuthorizationUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public final class Snws2AuthorizationBuilder
extends AbstractAuthorizationBuilder<Snws2AuthorizationBuilder> {
    public static final String SCHEME_NAME = "SNWS2";
    public static final String SIGNING_KEY_MESSAGE = "snws2_request";
    public static final String DEFAULT_HOST = "data.solarnetwork.net:443";
    private MultiValueMap<String, String> parameters;
    private Set<String> signedHeaderNames;
    private boolean useSnDate = false;

    public Snws2AuthorizationBuilder(String tokenId) {
        super(tokenId);
    }

    @Override
    public Snws2AuthorizationBuilder reset() {
        ((Snws2AuthorizationBuilder)super.reset()).host(DEFAULT_HOST);
        this.parameters = null;
        this.signedHeaderNames = null;
        return this;
    }

    public Snws2AuthorizationBuilder useSnDate(boolean useSnDate) {
        String discard;
        String want;
        this.useSnDate = useSnDate;
        MultiValueMap<String, String> headers = this.getHeaders();
        if (useSnDate) {
            want = "x-sn-date";
            discard = "date";
        } else {
            want = "date";
            discard = "x-sn-date";
        }
        boolean hasDiscard = headers.containsKey((Object)discard);
        if (!headers.containsKey((Object)want) && hasDiscard) {
            headers.put((Object)want, (Object)((List)headers.get((Object)discard)));
        }
        if (hasDiscard) {
            headers.remove((Object)discard);
        }
        return this;
    }

    public boolean isUseSnDate() {
        return this.useSnDate;
    }

    public Snws2AuthorizationBuilder method(String method) {
        return (Snws2AuthorizationBuilder)this.verb(method);
    }

    @Override
    public Snws2AuthorizationBuilder date(Instant date) {
        super.date(date);
        return (Snws2AuthorizationBuilder)this.header(this.useSnDate ? "x-sn-date" : "date", AuthorizationUtils.AUTHORIZATION_DATE_HEADER_FORMATTER.format(this.getDate()));
    }

    public Snws2AuthorizationBuilder contentType(String contentType) {
        return (Snws2AuthorizationBuilder)this.header("content-type", contentType);
    }

    public Snws2AuthorizationBuilder contentMD5(String md5) {
        return (Snws2AuthorizationBuilder)this.header("content-md5", md5);
    }

    public Snws2AuthorizationBuilder digest(String digest) {
        return (Snws2AuthorizationBuilder)this.header("digest", digest);
    }

    public Snws2AuthorizationBuilder parameterMap(Map<String, String[]> params) {
        LinkedMultiValueMap map = null;
        if (params != null) {
            map = new LinkedMultiValueMap(params.size());
            for (Map.Entry<String, String[]> me : params.entrySet()) {
                for (String v : me.getValue()) {
                    map.add((Object)me.getKey(), (Object)v);
                }
            }
        }
        this.parameters = map;
        return this;
    }

    public Snws2AuthorizationBuilder queryParams(Map<String, String> params) {
        LinkedMultiValueMap map = null;
        if (params != null) {
            map = new LinkedMultiValueMap(params.size());
            for (Map.Entry<String, String> me : params.entrySet()) {
                map.add((Object)me.getKey(), (Object)me.getValue());
            }
        }
        this.parameters = map;
        return this;
    }

    public Snws2AuthorizationBuilder signedHttpHeaders(Set<String> signedHeaderNames) {
        this.signedHeaderNames = signedHeaderNames;
        return this;
    }

    @Override
    public String[] sortedHeaderNames() {
        TreeSet<String> headerNames = new TreeSet<String>();
        int count = 0;
        if (this.signedHeaderNames != null && !this.signedHeaderNames.isEmpty()) {
            headerNames.addAll(this.signedHeaderNames);
            count += this.signedHeaderNames.size();
        } else {
            MultiValueMap<String, String> h = this.getHeaders();
            if (h != null) {
                for (String k : h.keySet()) {
                    if (k == null) continue;
                    headerNames.add(k.toLowerCase());
                    ++count;
                }
            }
        }
        if (headerNames.contains("date") && headerNames.contains("x-sn-date")) {
            headerNames.remove("date");
            --count;
        }
        return headerNames.toArray(new String[count]);
    }

    private void appendQueryParameters(StringBuilder buf) {
        Set paramKeys;
        Set set = paramKeys = this.parameters != null ? this.parameters.keySet() : Collections.emptySet();
        if (paramKeys.size() < 1) {
            buf.append('\n');
            return;
        }
        Object[] keys = paramKeys.toArray(new String[paramKeys.size()]);
        Arrays.sort(keys);
        boolean first = true;
        for (Object key : keys) {
            for (String val : (List)this.parameters.get(key)) {
                if (first) {
                    first = false;
                } else {
                    buf.append('&');
                }
                buf.append(AuthorizationUtils.uriEncode((CharSequence)key)).append('=').append(AuthorizationUtils.uriEncode(val));
            }
        }
        buf.append('\n');
    }

    @Override
    protected String signingKeyMessageLiteral() {
        return SIGNING_KEY_MESSAGE;
    }

    @Override
    protected String schemeName() {
        return SCHEME_NAME;
    }

    @Override
    protected String computeCanonicalRequestMessage(String[] headerNames) {
        StringBuilder buf = new StringBuilder(this.getVerb()).append('\n');
        buf.append(this.getPath()).append('\n');
        this.appendQueryParameters(buf);
        if (headerNames == null || headerNames.length < 1) {
            buf.append('\n').append('\n');
        } else {
            this.appendHeaders(headerNames, buf);
            buf.append(AuthorizationUtils.semiColonDelimitedList(headerNames)).append('\n');
        }
        this.appendContentSha256(buf);
        return buf.toString();
    }
}

